<?php

return array(
	'id'     => 'fastrans_banner_settings',
	'title'  => esc_html__( "Fastrans Banner Settings", "konia" ),
	'fields' => array(
		array(
			'id'      => 'banner_source_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Banner Source Type', 'fastrans' ),
			'options' => array(
				'd' => esc_html__( 'Default', 'fastrans' ),
				'e' => esc_html__( 'Elementor', 'fastrans' ),
			),
			'default' => '',
		),
		array(
			'id'       => 'banner_elementor_template',
			'type'     => 'select',
			'title'    => __( 'Template', 'viral-buzz' ),
			'data'     => 'posts',
			'args'     => [
				'post_type' => [ 'elementor_library' ],
				'posts_per_page'=> -1,
			],
			'required' => [ 'banner_source_type', '=', 'e' ],
		),
		array(
			'id'       => 'banner_page_banner',
			'type'     => 'switch',
			'title'    => esc_html__( 'Show Banner', 'fastrans' ),
			'default'  => false,
			'required' => [ 'banner_source_type', '=', 'd' ],
		),
		array(
			'id'       => 'banner_banner_title',
			'type'     => 'text',
			'title'    => esc_html__( 'Banner Section Title', 'fastrans' ),
			'desc'     => esc_html__( 'Enter the title to show in banner section', 'fastrans' ),
			'required' => array( 'banner_page_banner', '=', true ),
		),
		array(
			'id'       => 'banner_page_background',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__( 'Background Image', 'fastrans' ),
			'desc'     => esc_html__( 'Insert background image for banner', 'fastrans' ),
			'default'  => array(
				'url' => FASTRANS_URI . 'assets/images/bg/bread-bg.jpg',
			),
			'required' => array( 'banner_page_banner', '=', true ),
		),
	),
);