<?php
///----Blog widgets---
//Recent News
class Fastrans_Recent_News extends WP_Widget
{
    /** constructor */
    public function __construct()
    {
        parent::__construct( /* Base ID */'Fastrans_Recent_News', /* Name */esc_html__('Fastrans Recent News', 'fastrans'), array( 'description' => esc_html__('Show the Recent News', 'fastrans')));
    }


    /** @see WP_Widget::widget */
    public function widget($args, $instance)
    {
        extract($args);
        $title = apply_filters('widget_title', $instance['title']);

        echo wp_kses_post($before_widget); ?>

		<!--Start Single Sidebar Box-->
        <div class="recent-post">
            <div class="recent-news-widget">
                <?php echo wp_kses_post($before_title.$title.$after_title); ?>

				<?php $query_string = array('showposts'=>$instance['number']);
					if ($instance['cat']) {
						$query_string['tax_query'] = array(array('taxonomy' => 'category','field' => 'id','terms' => (array)$instance['cat']));
					}
					$this->posts($query_string);
				?>

            </div>
        </div>

        <?php echo wp_kses_post($after_widget);
    }


    /** @see WP_Widget::update */
    public function update($new_instance, $old_instance)
    {
        $instance = $old_instance;

        $instance['title'] = strip_tags($new_instance['title']);
        $instance['number'] = $new_instance['number'];
        $instance['cat'] = $new_instance['cat'];

        return $instance;
    }

    /** @see WP_Widget::form */
    public function form($instance)
    {
        $title = ($instance) ? esc_attr($instance['title']) : esc_html__('Recent News', 'fastrans');
        $number = ($instance) ? esc_attr($instance['number']) : 3;
        $cat = ($instance) ? esc_attr($instance['cat']) : ''; ?>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'fastrans'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'fastrans'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr($number); ?>" />
        </p>
		<p>
            <label for="<?php echo esc_attr($this->get_field_id('categories')); ?>"><?php esc_html_e('Category', 'fastrans'); ?></label>
            <?php wp_dropdown_categories(array('show_option_all'=>esc_html__('All Categories', 'fastrans'), 'taxonomy' => 'category', 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('cat'))); ?>
        </p>

        <?php
    }

    public function posts($query_string)
    {
        $query = new WP_Query($query_string);
        if ($query->have_posts()):?>

            <!-- Title -->
            <?php
                global $post;
				while ($query->have_posts()): $query->the_post();
				$post_thumbnail_id = get_post_thumbnail_id($post->ID);
				$post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id);
			?>
            <div class="recent-blog-img-text clearfix">
                <div class="recent-blog-img" style="background-image:url(<?php echo esc_url($post_thumbnail_url); ?>); "></div>
                <div class="recent-blog-text headline">
                    <h3><a href="<?php echo esc_url(get_the_permalink(get_the_id())); ?>"><?php the_title(); ?></a></h3>
                    <span><i class="far fa-calendar"></i> <?php echo get_the_date(); ?></span>
                </div>
            </div>
            <?php endwhile; ?>

        <?php endif;
        wp_reset_postdata();
    }
}

//Bussiness Add
class Fastrans_Bussiness_Add extends WP_Widget
{

	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Fastrans_Bussiness_Add', /* Name */esc_html__('Fastrans Bussiness Add','fastrans'), array( 'description' => esc_html__('Show the Bussiness Add', 'fastrans' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );

		echo wp_kses_post($before_widget);?>

			<!--Start Single Sidebar Box-->
            <div class="business-add">
                <a href="<?php echo esc_url( home_url( '/' ) );?>"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/images/logo/l-icon.png" alt="<?php echo esc_attr_e( 'Awesome Image', 'fastrans' );?>"></a>
                <h2>Cargo & Logistics Business Services</h2>
                <a href="<?php echo wp_kses_post($instance['add_link']); ?>" class="d-flex justify-content-center align-items-center ft-btn">Contact Now</a>
            </div>

        <?php

		echo wp_kses_post($after_widget);
	}


	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['add_link'] = strip_tags($new_instance['add_link']);


		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$add_link = ($instance) ? esc_attr($instance['add_link']) : '#';

		?>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('add_img')); ?>"><?php esc_html_e('Enter Image Url:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('Image Url', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('add_img')); ?>" name="<?php echo esc_attr($this->get_field_name('add_img')); ?>" type="text" value="<?php echo esc_attr($add_img); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('add_link')); ?>"><?php esc_html_e('Enter Link:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('#', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('add_link')); ?>" name="<?php echo esc_attr($this->get_field_name('add_link')); ?>" type="text" value="<?php echo esc_attr($add_link); ?>" />
        </p>

		<?php
	}

}

//Our Projects
class Fastrans_Our_Projects extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Fastrans_Our_Projects', /* Name */esc_html__('Fastrans Our Projects','Fastrans'), array( 'description' => esc_html__('Show the Our Projects', 'Fastrans' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );

		echo wp_kses_post($before_widget); ?>

        <!-- Instagram Widget -->
        <div class="gallery-post">
            <div class="gallery-widget">
                <?php echo wp_kses_post($before_title.$title.$after_title); ?>
                <ul class="zoom-gallery">
                    <?php
						$args = array('post_type' => 'project', 'showposts'=>$instance['number']);
						if( $instance['cat'] ) $args['tax_query'] = array(array('taxonomy' => 'project_cat','field' => 'id','terms' => (array)$instance['cat']));
						$this->posts($args);
                    ?>
                </ul>
            </div>
        </div>

        <?php echo wp_kses_post($after_widget);
	}


	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = $new_instance['title'];
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];

		return $instance;
	}
	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : 'Our Projects';
		$number = ( $instance ) ? esc_attr($instance['number']) : 6;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';
		?>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'Fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('Our Projects', 'Fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of posts: ', 'Fastrans'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'Fastrans'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'Fastrans'), 'selected'=>$cat, 'taxonomy' => 'project_cat', 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>

		<?php
	}

	function posts($args)
	{

		$query = new WP_Query($args);
		if( $query->have_posts() ):?>

           	<!-- Title -->
            <?php
				global $post;
				while( $query->have_posts() ): $query->the_post();
				$post_thumbnail_id = get_post_thumbnail_id($post->ID);
				$post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id);
			?>
            <li class="image" style="background-image:url('<?php echo esc_url($post_thumbnail_url);?>');">
                <a href="<?php echo esc_url($post_thumbnail_url);?>" data-source="<?php echo esc_url($post_thumbnail_url);?>"></a>
            </li>
            <?php endwhile; ?>

        <?php endif;
		wp_reset_postdata();
    }
}


///----Service Sidebar widgets---
//Service Sidebar

class Fastrans_Service_Sidebar extends WP_Widget
	{
		/** constructor */
		function __construct()
		{
			parent::__construct( /* Base ID */'Fastrans_Service_Sidebar', /* Name */esc_html__('Fastrans Service Sidebar','fastrans'), array( 'description' => esc_html__('Show the Service Sidebar', 'fastrans' )) );
		}

		/** @see WP_Widget::widget */
		function widget($args, $instance)
		{
			extract( $args );
			$title = apply_filters( 'widget_title', $instance['title'] );

			echo wp_kses_post($before_widget); ?>

			<!-- Instagram Widget -->
			<div class="ft-service-sidebar-widget headline ul-li-block">
				<div class="service-category-widget">
					<?php echo wp_kses_post($before_title.$title.$after_title); ?>
					<ul>
					<?php
						$args = array('post_type' => 'service', 'showposts'=>$instance['number']);
						if( $instance['cat'] ) $args['tax_query'] = array(array('taxonomy' => 'service_cat','field' => 'id','terms' => (array)$instance['cat']));

						// Add order to the query arguments
						$args['order'] = $instance['order'];

						$this->posts($args);
					?>
					</ul>
				</div>
			</div>

			<?php echo wp_kses_post($after_widget);
		}

		/** @see WP_Widget::update */
		function update($new_instance, $old_instance)
		{
			$instance = $old_instance;

			$instance['title'] = strip_tags($new_instance['title']);
			$instance['number'] = $new_instance['number'];
			$instance['cat'] = $new_instance['cat'];
			$instance['order'] = $new_instance['order']; // Add order option

			return $instance;
		}

		/** @see WP_Widget::form */
		function form($instance)
		{
			$title = ($instance) ? esc_attr($instance['title']) : 'Services';
			$number = ( $instance ) ? esc_attr($instance['number']) : 6;
			$cat = ( $instance ) ? esc_attr($instance['cat']) : '';
			$order = ( $instance && isset($instance['order']) ) ? esc_attr($instance['order']) : 'desc'; // Add order option and set default to 'desc'
			?>

			<p>
				<label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'fastrans'); ?></label>
				<input placeholder="<?php esc_attr_e('Popular Gallery', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
			</p>
			<p>
				<label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of posts: ', 'fastrans'); ?></label>
				<input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
			</p>
			<p>
				<label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'fastrans'); ?></label>
				<?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'fastrans'), 'selected'=>$cat, 'taxonomy' => 'service_cat', 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
			</p>
			<p>
				<label for="<?php echo esc_attr($this->get_field_id('order')); ?>"><?php esc_html_e('Order', 'fastrans'); ?></label>
				<select id="<?php echo esc_attr($this->get_field_id('order')); ?>" name="<?php echo esc_attr($this->get_field_name('order')); ?>" class="widefat">
					<option value="asc" <?php selected('asc', $order); ?>><?php esc_html_e('Ascending', 'fastrans'); ?></option>
					<option value="desc" <?php selected('desc', $order); ?>><?php esc_html_e('Descending', 'fastrans'); ?></option>
				</select>
			</p>

			<?php
		}

		function posts($args)
		{
			$query = new WP_Query($args);
			if( $query->have_posts() ):?>

				<!-- Title -->
				<?php
					while( $query->have_posts() ): $query->the_post();
				?>
				<li><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'service_url', true ));?>"><?php the_title(); ?></a></li>
				<?php endwhile; ?>

			<?php endif;
			wp_reset_postdata

	();
	}
}

//Support Form
class Fastrans_Support_Form extends WP_Widget
{

	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Fastrans_Support_Form', /* Name */esc_html__('Fastrans Support Form','fastrans'), array( 'description' => esc_html__('Show the Support Form', 'fastrans' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );

		echo wp_kses_post($before_widget);?>

			<div class="ft-service-sidebar-widget headline ul-li-block">
                <div class="service-form-widget">
                    <?php if($instance['title']){ ?><h3 class="widget-title text-uppercase"><?php echo wp_kses_post($instance['title']); ?></h3><?php } ?>
                    <?php if($instance['content']){ ?>
                    <p><?php echo wp_kses_post($instance['content']); ?></p>
                    <?php } ?>
                    <?php echo do_shortcode($instance['support_form_url']); ?>
                </div>
            </div>

        <?php

		echo wp_kses_post($after_widget);
	}


	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = strip_tags($new_instance['title']);
		$instance['content'] = $new_instance['content'];
		$instance['support_form_url'] = $new_instance['support_form_url'];


		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{

		$title = ($instance) ? esc_attr($instance['title']) : '24/7 ONLINE SUPPORT';
		$content = ($instance) ? esc_attr($instance['content']) : '';
		$support_form_url = ($instance) ? esc_attr($instance['support_form_url']) : '';
		?>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Enter Title:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('24/7 ONLINE SUPPORT', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Content:', 'fastrans'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses_post($content); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('support_form_url')); ?>"><?php esc_html_e('Support Form Url:', 'fastrans'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('support_form_url')); ?>" name="<?php echo esc_attr($this->get_field_name('support_form_url')); ?>" ><?php echo wp_kses_post($support_form_url); ?></textarea>
        </p>

		<?php
	}

}

//Download Brochure
class Fastrans_Download_Brochure extends WP_Widget
{

	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Fastrans_Download_Brochure', /* Name */esc_html__('Fastrans Download Brochure','fastrans'), array( 'description' => esc_html__('Show the Download Brochure', 'fastrans' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );

		echo wp_kses_post($before_widget);?>

		<div class="ft-service-sidebar-widget headline ul-li-block">
            <div class="service-download-widget">
                <?php echo wp_kses_post($before_title.$title.$after_title); ?>
                <ul>
                    <?php if($instance['pdf_file_title'] || $instance['pdf_file_link'] ){ ?>
                    <li><a target="_blank" href="<?php echo esc_url($instance['pdf_file_link']); ?>"><?php echo wp_kses_post($instance['pdf_file_title']); ?> <i class="far fa-file-pdf"></i></a></li>
                    <?php } ?>
                    <?php if($instance['doc_file_title'] || $instance['doc_file_link'] ){ ?>
                    <li><a target="_blank" href="<?php echo esc_url($instance['doc_file_link']); ?>"><?php echo wp_kses_post($instance['doc_file_title']); ?> <i class="far fa-file-pdf"></i></a></li>
                    <?php } ?>
                </ul>
            </div>
        </div>

        <?php

		echo wp_kses_post($after_widget);
	}


	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['pdf_file_title'] = strip_tags($new_instance['pdf_file_title']);
		$instance['pdf_file_link'] = $new_instance['pdf_file_link'];
		$instance['doc_file_title'] = $new_instance['doc_file_title'];
		$instance['doc_file_link'] = $new_instance['doc_file_link'];


		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ($instance) ? esc_attr($instance['title']) : 'Download Now';
		$pdf_file_title = ($instance) ? esc_attr($instance['pdf_file_title']) : 'Compnay Report -2020';
		$pdf_file_link = ($instance) ? esc_attr($instance['pdf_file_link']) : '#';
		$doc_file_title = ($instance) ? esc_attr($instance['doc_file_title']) : 'Compnay Report -2021';
		$doc_file_link = ($instance) ? esc_attr($instance['doc_file_link']) : '#';
		?>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Enter Title:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('Download Now', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('pdf_file_title')); ?>"><?php esc_html_e('Enter PDF File Title:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('Compnay Report -2020', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('pdf_file_title')); ?>" name="<?php echo esc_attr($this->get_field_name('pdf_file_title')); ?>" type="text" value="<?php echo esc_attr($pdf_file_title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('pdf_file_link')); ?>"><?php esc_html_e('Enter PDF Link:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('#', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('pdf_file_link')); ?>" name="<?php echo esc_attr($this->get_field_name('pdf_file_link')); ?>" type="text" value="<?php echo esc_attr($pdf_file_link); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('doc_file_title')); ?>"><?php esc_html_e('Enter DOC File Title:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('Compnay Report -2021', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('doc_file_title')); ?>" name="<?php echo esc_attr($this->get_field_name('doc_file_title')); ?>" type="text" value="<?php echo esc_attr($doc_file_title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('doc_file_link')); ?>"><?php esc_html_e('DOC File Link:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('#', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('doc_file_link')); ?>" name="<?php echo esc_attr($this->get_field_name('doc_file_link')); ?>" type="text" value="<?php echo esc_attr($doc_file_link); ?>" />
        </p>


		<?php
	}
}


///----footer widgets---
//About Company
class Fastrans_About_Company extends WP_Widget
{

	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Fastrans_About_Company', /* Name */esc_html__('Fastrans About Company','fastrans'), array( 'description' => esc_html__('Show the About Company', 'fastrans' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );

		echo wp_kses_post($before_widget);?>

			<div class="ft-footer-logo-widget headline pera-content">
                <?php if($instance['widget_logo_img']){ ?>
                <div class="ft-footer-logo">
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url($instance['widget_logo_img']); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></a>
                </div>
                <?php } ?>
                <p><?php echo wp_kses_post($instance['content']); ?></p>
                <?php if($instance['widget_btn_link'] || $instance['widget_btn_title']){ ?>
                <a class="footer-logo-btn text-center text-uppercase" href="<?php echo esc_url($instance['widget_btn_link']); ?>"><?php echo wp_kses_post($instance['widget_btn_title']); ?></a>
                <?php } ?>
            </div>

        <?php

		echo wp_kses_post($after_widget);
	}


	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['widget_logo_img'] = $new_instance['widget_logo_img'];
		$instance['content'] = $new_instance['content'];
		$instance['widget_btn_title'] = $new_instance['widget_btn_title'];
		$instance['widget_btn_link'] = $new_instance['widget_btn_link'];

		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$widget_logo_img = ($instance) ? esc_attr($instance['widget_logo_img']) : 'http://themexriver.com/wp/fastrans/wp-content/uploads/2021/10/logo2.png';
		$content = ($instance) ? esc_attr($instance['content']) : '';
		$widget_btn_title = ($instance) ? esc_attr($instance['widget_btn_title']) : '';
		$widget_btn_link = ($instance) ? esc_attr($instance['widget_btn_link']) : '';
		?>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('widget_logo_img')); ?>"><?php esc_html_e('Enter Logo Image:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('Image Url', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('widget_logo_img')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_logo_img')); ?>" type="text" value="<?php echo esc_attr($widget_logo_img); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Content:', 'fastrans'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses_post($content); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('widget_btn_title')); ?>"><?php esc_html_e('Enter Button Title:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('About Us', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('widget_btn_title')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_btn_title')); ?>" type="text" value="<?php echo esc_attr($widget_btn_title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('widget_btn_link')); ?>"><?php esc_html_e('Enter Button Link:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('#', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('widget_btn_link')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_btn_link')); ?>" type="text" value="<?php echo esc_attr($widget_btn_link); ?>" />
        </p>

		<?php
	}

}

//Newsletter
class Fastrans_Newsletter extends WP_Widget
{

	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Fastrans_Newsletter', /* Name */esc_html__('Fastrans Newsletter','fastrans'), array( 'description' => esc_html__('Show the Newsletter', 'fastrans' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );

		echo wp_kses_post($before_widget);?>


            <!--Start single footer widget-->
         	<div class="ft-footer-newslatter-widget pera-content headline">
                <?php echo wp_kses_post($before_title.$title.$after_title); ?>
                <p><?php echo wp_kses_post($instance['content']); ?></p>

				<?php echo do_shortcode($instance['mailchimp_form_url2']); ?>

                <?php if( $instance['show'] ): ?>
				<?php echo wp_kses_post(fastrans_get_social_icon()); ?>
                <?php endif; ?>

            </div>

        <?php

		echo wp_kses_post($after_widget);
	}


	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = strip_tags($new_instance['title']);
		$instance['content'] = strip_tags($new_instance['content']);
		$instance['mailchimp_form_url2'] = $new_instance['mailchimp_form_url2'];
		$instance['show'] = $new_instance['show'];


		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{

		$title = ($instance) ? esc_attr($instance['title']) : 'Newsletter';
		$content = ($instance) ? esc_attr($instance['content']) : '';
		$mailchimp_form_url2 = ($instance) ? esc_attr($instance['mailchimp_form_url2']) : '';
		$show = ($instance) ? esc_attr($instance['show']) : '';
		?>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Enter Title:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('Newsletter', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Description:', 'fastrans'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses_post($content); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('mailchimp_form_url2')); ?>"><?php esc_html_e('MailChimp Form Url:', 'fastrans'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('mailchimp_form_url2')); ?>" name="<?php echo esc_attr($this->get_field_name('mailchimp_form_url2')); ?>" ><?php echo wp_kses_post($mailchimp_form_url2); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('show')); ?>"><?php esc_html_e('Show Social Icons:', 'fastrans'); ?></label>
			<?php $selected = ( $show ) ? ' checked="checked"' : ''; ?>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('show')); ?>"<?php echo esc_attr($selected); ?> name="<?php echo esc_attr($this->get_field_name('show')); ?>" type="checkbox" value="true" />
        </p>


		<?php
	}

}

//Contact Info
class Fastrans_Contact_Info extends WP_Widget
{

	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Fastrans_Contact_Info', /* Name */esc_html__('Fastrans Contact Info','fastrans'), array( 'description' => esc_html__('Show the Contact Info', 'fastrans' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );

		echo wp_kses_post($before_widget);?>


            <!--Start single footer widget-->
         	<div class="ft-footer-newslatter-widget pera-content headline">
                <div class="ft-footer-info-widget ul-li ">
                    <?php echo wp_kses_post($before_title.$title.$after_title); ?>
                    <ul>
                        <?php if($instance['address']){ ?>
                        <li>
                            <i class="fas fa-map-marker-alt"></i>
                            <p><?php echo wp_kses_post($instance['address']); ?></p>
                        </li>
                        <?php } ?>
                        <?php if($instance['phone_no']){ ?>
                        <li>
                            <i class="fas fa-phone"></i><a href="tel:<?php echo esc_attr($instance['phone_no']); ?>"><?php echo wp_kses_post($instance['phone_no']); ?></a>
                        </li>
                        <?php } ?>
                    </ul>
                    <?php if($instance['subheading'] || $instance['opening_hours']){ ?>
                    <div class="office-open-hour">
                        <?php if($instance['subheading']){ ?><span><?php echo wp_kses_post($instance['subheading']); ?> </span><?php } ?>
                        <?php if($instance['opening_hours']){ ?><p><?php echo wp_kses_post($instance['opening_hours']); ?></p><?php } ?>
                    </div>
                    <?php } ?>
                </div>
            </div>

        <?php

		echo wp_kses_post($after_widget);
	}


	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = strip_tags($new_instance['title']);
		$instance['address'] = $new_instance['address'];
		$instance['phone_no'] = $new_instance['phone_no'];
		$instance['subheading'] = $new_instance['subheading'];
		$instance['opening_hours'] = $new_instance['opening_hours'];


		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{

		$title = ($instance) ? esc_attr($instance['title']) : 'Official info:';
		$address = ($instance) ? esc_attr($instance['address']) : '';
		$phone_no = ($instance) ? esc_attr($instance['phone_no']) : '';
		$subheading = ($instance) ? esc_attr($instance['subheading']) : '';
		$opening_hours = ($instance) ? esc_attr($instance['opening_hours']) : '';
		?>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Enter Title:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('Official info:', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('address')); ?>"><?php esc_html_e('Address:', 'fastrans'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('address')); ?>" name="<?php echo esc_attr($this->get_field_name('address')); ?>" ><?php echo wp_kses_post($address); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone_no')); ?>"><?php esc_html_e('Phone Number:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('+1-800-555-44-678', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('phone_no')); ?>" name="<?php echo esc_attr($this->get_field_name('phone_no')); ?>" type="text" value="<?php echo esc_attr($phone_no); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('subheading')); ?>"><?php esc_html_e('Sub Heading:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('Open Hours:', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('subheading')); ?>" name="<?php echo esc_attr($this->get_field_name('subheading')); ?>" type="text" value="<?php echo esc_attr($subheading); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('opening_hours')); ?>"><?php esc_html_e('Opening Hours:', 'fastrans'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('opening_hours')); ?>" name="<?php echo esc_attr($this->get_field_name('opening_hours')); ?>" ><?php echo wp_kses_post($opening_hours); ?></textarea>
        </p>

		<?php
	}

}

//Our Projects V2
class Fastrans_Our_Projects_V2 extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Fastrans_Our_Projects_V2', /* Name */esc_html__('Fastrans Our Projects V2','Fastrans'), array( 'description' => esc_html__('Show the Our Projects V2', 'Fastrans' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );

		echo wp_kses_post($before_widget); ?>

        <!-- Instagram Widget -->
        <div class="pera-content">
            <div class="gallery-widget clearfix">
                <?php echo wp_kses_post($before_title.$title.$after_title); ?>
                <ul class="zoom-gallery">
                   <?php
						$args = array('post_type' => 'project', 'showposts'=>$instance['number']);
						if( $instance['cat'] ) $args['tax_query'] = array(array('taxonomy' => 'project_cat','field' => 'id','terms' => (array)$instance['cat']));
						$this->posts($args);
                   ?>
                </ul>
            </div>
        </div>

        <?php echo wp_kses_post($after_widget);
	}


	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = $new_instance['title'];
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];

		return $instance;
	}
	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : 'Our Projects';
		$number = ( $instance ) ? esc_attr($instance['number']) : 6;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';
		?>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'Fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('Our Projects', 'Fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of posts: ', 'Fastrans'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'Fastrans'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'Fastrans'), 'selected'=>$cat, 'taxonomy' => 'project_cat', 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>

		<?php
	}

	function posts($args)
	{

		$query = new WP_Query($args);
		if( $query->have_posts() ):?>

           	<!-- Title -->
            <?php
				global $post;
				while( $query->have_posts() ): $query->the_post();
				$post_thumbnail_id = get_post_thumbnail_id($post->ID);
				$post_thumbnail_url = wp_get_attachment_url($post_thumbnail_id);
			?>
            <li class="image" style="background-image:url('<?php echo esc_url($post_thumbnail_url);?>');">
                <a href="<?php echo esc_url($post_thumbnail_url);?>" data-source="<?php echo esc_url($post_thumbnail_url);?>"></a>
            </li>
            <?php endwhile; ?>

        <?php endif;
		wp_reset_postdata();
    }
}



///----footer Two widgets---
//About Company V2
class Fastrans_About_Company_V2 extends WP_Widget
{

	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Fastrans_About_Company_V2', /* Name */esc_html__('Fastrans About Company V2','fastrans'), array( 'description' => esc_html__('Show the About Company V2', 'fastrans' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );

		echo wp_kses_post($before_widget);?>

			<div class="pera-content">
                <div class="logo-widget">
                    <?php if($instance['widget_logo_img']){ ?>
                    <div class="site-logo">
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url($instance['widget_logo_img']); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></a>
                    </div>
                    <?php } ?>
                    <p><?php echo wp_kses_post($instance['content']); ?> </p>
                    <?php if($instance['widget_btn_link'] || $instance['widget_btn_title']){ ?>
                    <div class="ft-btn">
                        <a class="d-flex justify-content-center align-items-center" href="<?php echo esc_url($instance['widget_btn_link']); ?>"><?php echo wp_kses_post($instance['widget_btn_title']); ?></a>
                    </div>
                    <?php } ?>
                </div>
            </div>

        <?php

		echo wp_kses_post($after_widget);
	}


	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['widget_logo_img'] = $new_instance['widget_logo_img'];
		$instance['content'] = $new_instance['content'];
		$instance['widget_btn_title'] = $new_instance['widget_btn_title'];
		$instance['widget_btn_link'] = $new_instance['widget_btn_link'];

		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$widget_logo_img = ($instance) ? esc_attr($instance['widget_logo_img']) : 'http://themexriver.com/wp/fastrans/wp-content/uploads/2021/10/logo2.png';
		$content = ($instance) ? esc_attr($instance['content']) : '';
		$widget_btn_title = ($instance) ? esc_attr($instance['widget_btn_title']) : '';
		$widget_btn_link = ($instance) ? esc_attr($instance['widget_btn_link']) : '';
		?>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('widget_logo_img')); ?>"><?php esc_html_e('Enter Logo Image:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('Image Url', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('widget_logo_img')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_logo_img')); ?>" type="text" value="<?php echo esc_attr($widget_logo_img); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Content:', 'fastrans'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses_post($content); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('widget_btn_title')); ?>"><?php esc_html_e('Enter Button Title:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('About Us', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('widget_btn_title')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_btn_title')); ?>" type="text" value="<?php echo esc_attr($widget_btn_title); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('widget_btn_link')); ?>"><?php esc_html_e('Enter Button Link:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('#', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('widget_btn_link')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_btn_link')); ?>" type="text" value="<?php echo esc_attr($widget_btn_link); ?>" />
        </p>

		<?php
	}

}


///----footer Three widgets---
//About Company V3
class Fastrans_About_Company_V3 extends WP_Widget
{

	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Fastrans_About_Company_V3', /* Name */esc_html__('Fastrans About Company V3','fastrans'), array( 'description' => esc_html__('Show the About Company V3', 'fastrans' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );

		echo wp_kses_post($before_widget);?>

			<div class="pera-content">
                <div class="logo-widget">
                    <?php if($instance['widget_logo_img']){ ?>
                    <div class="site-logo">
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url($instance['widget_logo_img']); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></a>
                    </div>
                    <?php } ?>
                    <div class="ft-footer-address">
                        <?php if($instance['widget_address_v3']){ ?><span><?php echo wp_kses_post($instance['widget_address_v3']); ?></span><?php } ?>
                        <?php if($instance['widget_website_link']){ ?><span><?php echo wp_kses_post($instance['widget_website_link']); ?></span><?php } ?>
                        <?php if($instance['widget_email_v3']){ ?><span><?php echo wp_kses_post($instance['widget_email_v3']); ?></span><?php } ?>
						<?php if($instance['widget_phone_v3']){ ?><span><?php echo wp_kses_post($instance['widget_phone_v3']); ?></span><?php } ?>
                    </div>
                </div>
            </div>

        <?php

		echo wp_kses_post($after_widget);
	}


	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['widget_logo_img'] = $new_instance['widget_logo_img'];
		$instance['widget_address_v3'] = $new_instance['widget_address_v3'];
		$instance['widget_website_link'] = $new_instance['widget_website_link'];
		$instance['widget_email_v3'] = $new_instance['widget_email_v3'];
		$instance['widget_phone_v3'] = $new_instance['widget_phone_v3'];

		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$widget_logo_img = ($instance) ? esc_attr($instance['widget_logo_img']) : 'http://themexriver.com/wp/fastrans/wp-content/uploads/2021/10/logo4.png';
		$widget_address_v3 = ($instance) ? esc_attr($instance['widget_address_v3']) : '';
		$widget_website_link = ($instance) ? esc_attr($instance['widget_website_link']) : '';
		$widget_email_v3 = ($instance) ? esc_attr($instance['widget_email_v3']) : '';
		$widget_phone_v3 = ($instance) ? esc_attr($instance['widget_phone_v3']) : '';

		?>

        <p>
            <label for="<?php echo esc_attr($this->get_field_id('widget_logo_img')); ?>"><?php esc_html_e('Enter Logo Image:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('Image Url', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('widget_logo_img')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_logo_img')); ?>" type="text" value="<?php echo esc_attr($widget_logo_img); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('widget_address_v3')); ?>"><?php esc_html_e('Address:', 'fastrans'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('widget_address_v3')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_address_v3')); ?>" ><?php echo wp_kses_post($widget_address_v3); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('widget_website_link')); ?>"><?php esc_html_e('Enter Website Link:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('#', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('widget_website_link')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_website_link')); ?>" type="text" value="<?php echo esc_attr($widget_website_link); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('widget_email_v3')); ?>"><?php esc_html_e('Enter Email Address:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('info@example.com', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('widget_email_v3')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_email_v3')); ?>" type="text" value="<?php echo esc_attr($widget_email_v3); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('widget_phone_v3')); ?>"><?php esc_html_e('Enter Phone No:', 'fastrans'); ?></label>
            <input placeholder="<?php esc_attr_e('111-2222-333', 'fastrans');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('widget_phone_v3')); ?>" name="<?php echo esc_attr($this->get_field_name('widget_phone_v3')); ?>" type="text" value="<?php echo esc_attr($widget_phone_v3); ?>" />
        </p>

		<?php
	}

}
