<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Transport_Slider extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrance_transport_slider';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Transport Slider Section', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}

	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'transport_slider',
			[
				'label' => esc_html__( 'Slider Option', 'fastrans' ),
			]
		);
		$repeater = new Repeater();

		$repeater->add_control(
			'slider_bg_img', [
				'label'       => esc_html__( 'Background Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'description', [
				'label'       => esc_html__( 'Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'btn_label', [
				'label'       => esc_html__( 'Button Label', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'btn_link',
			[
				'label' => __( 'Link', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'fastrans' ),
			]
		);
		$this->add_control(
			'transport_slides',
			[
				'label'       => __( 'Add Item', 'fastrans-extension' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_1',
			[
				'label' => __( 'Section Style', 'fastrans' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'Title-Color',
			[
				'label' => esc_html__( 'Title Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slide-two-content .inner-box .image-box .content-inner h2 a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Title-Typography',
				'label' => esc_html__( 'Title Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .slide-two-content .inner-box .image-box .content-inner h2 a',
			]
		);
		$this->add_control(
			'Title-Hover-Color',
			[
				'label' => esc_html__( 'Title Hover Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slide-two-content .inner-box .image-box .content-inner h2 a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Description-Color',
			[
				'label' => esc_html__( 'Description Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slide-two-content .inner-box .image-box .content-inner .text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Description-Typography',
				'label' => esc_html__( 'Description Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .slide-two-content .inner-box .image-box .content-inner .text',
			]
		);
		$this->add_control(
			'--Button-Style--',
			[
				'label' => esc_html__( 'Button Style', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->start_controls_tabs('tpcnt');
		$this->start_controls_tab(
			'tab_controls_normal',
			[
				'label' => esc_html__( 'Normal', 'appilo' ),
			]
		);
		$this->add_control(
			'Button-Color',
			[
				'label' => esc_html__( 'Button Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slide-two-content .inner-box .image-box .content-inner .read-more' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Button-Typography',
				'label' => esc_html__( 'Button Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .slide-two-content .inner-box .image-box .content-inner .read-more',
			]
		);
		$this->add_control(
			'Button-BG-Color',
			[
				'label' => esc_html__( 'Button BG Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slide-two-content .inner-box .image-box .content-inner .read-more' => 'background: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_controls_hover',
			[
				'label' => esc_html__( 'Hover', 'appilo' ),
			]
		);
		$this->add_control(
			'Button-Hover-Color',
			[
				'label' => esc_html__( 'Button Hover Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slide-two-content .inner-box .image-box .content-inner .read-more:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Button-Hover-BG-Color',
			[
				'label' => esc_html__( 'Button Hover BG Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slide-two-content .inner-box .image-box .content-inner .read-more:hover' => 'background: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
			'Tab_style_1',
			[
				'label' => __( 'Tab Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs('tpcnt_Tab');
		$this->start_controls_tab(
			'tab_controls_normal_Tab',
			[
				'label' => esc_html__( 'Normal', 'appilo' ),
			]
		);
		$this->add_control(
			'Tab-Button-Color',
			[
				'label' => esc_html__( 'Tab Button Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-slider-two .product-details .image-column .thumbs-carousel li' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Tab-Button-Typography',
				'label' => esc_html__( 'Tab Button Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .main-slider-two .product-details .image-column .thumbs-carousel li',
			]
		);
		$this->add_control(
			'Tab-Button-BG-Color',
			[
				'label' => esc_html__( 'Tab Button BG Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-slider-two .product-details .image-column .thumbs-carousel li' => 'background: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_controls_hover_Tab',
			[
				'label' => esc_html__( 'Hover', 'appilo' ),
			]
		);
		$this->add_control(
			'Tab-Button-Hover-Color',
			[
				'label' => esc_html__( 'Tab Button Hover Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-slider-two .product-details .image-column .thumbs-carousel li:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Tab-Button-Hover-BG-Color',
			[
				'label' => esc_html__( 'Tab Button Hover BG Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-slider-two .product-details .image-column .thumbs-carousel li:hover' => 'background: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $transport_slides = $settings['transport_slides'];
    ?>
        <!-- Main Slider Two -->
        <section class="ft3-main-slider-two">

		<!-- Shop Single -->
		<div class="product-details">

			<!-- Basic Details -->
			<div class="basic-details">
				<div class="image-column">
					<div class="carousel-outer">
						<div class="image-carousel-2">

							<!--Slide-->
							<?php foreach($transport_slides as $item):?>
							<div class="slide-two-content">
								<div class="inner-box">
									<div class="pattern-layer"></div>
									<div class="image-box">
										<div class="image">
											<?php if(!empty( $item['slider_bg_img']['url'] )) : ?>
											<img class="wow fadeIn" data-wow-delay="0ms" data-wow-duration="2500ms" src="<?php echo esc_url($item['slider_bg_img']['url']);?>" alt="" />
											<?php endif;?>
											<div class="overlay-box">
												<div class="overlay-inner">
													<div class="content">
														<div class="content-inner">
															<?php if(!empty( $item['title'] )) : ?>
															<h2><a href="<?php echo esc_url($item['btn_link']['url']);?>">
															<?php echo esc_html($item['title']);?></a></h2>
															<?php endif;?>

															<?php if(!empty( $item['description'] )) : ?>
															<div class="text"><?php echo esc_html($item['description']);?></div>
															<?php endif;?>

															<?php if(!empty( $item['btn_label'] )) : ?>
															<a href="<?php echo esc_url($item['btn_link']['url']);?>" class="read-more theme-btn">
																<?php echo esc_html($item['btn_label']);?>
															</a>
															<?php endif;?>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
							<?php endforeach;?>

						</div>

						<div class="thumbs-carousel-2">
							<?php foreach($transport_slides as $item):?>
							<div class="list-item"><?php echo esc_html($item['title']);?></div>
							<?php endforeach;?>
						</div>

					</div>
				</div>

			</div>
			<!--Basic Details-->

		</div>

	</section>
        <!-- End Main Slider Two -->
	<?php
	}

}
