<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Transport_Contact_Info extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrance_contact_info';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Transport Contact Info', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'transport_slider',
			[
				'label' => esc_html__( 'Slider Option', 'fastrans' ),
			]
		);
        $this->add_control(
			'sub_heading', [
				'label'       => esc_html__( 'Sub Heading', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'heading', [
				'label'       => esc_html__( 'Heading', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		$repeater = new Repeater();
		
		$repeater->add_control(
			'info_icon',
			[
				'label' => esc_html__( 'Icon', 'plugin-name' ),
				'type' => Controls_Manager::ICONS,
			]
		);
		$repeater->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'content', [
				'label'       => esc_html__( 'Content', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'con_info', [
				'label'       => esc_html__( 'Contact Info', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'info_url',
			[
				'label' => __( 'Info URL', 'fastrans' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'contact_infos',
			[
				'label'       => __( 'Add Item', 'fastrans-extension' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_1',
			[
				'label' => __( 'Section Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'--Top-Heading-Style--',
			[
				'label' => esc_html__( 'Top Heading Style', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Sub-Heading-Color',
			[
				'label' => esc_html__( 'Sub Heading Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two.style-two .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Sub-Heading-Typography',
				'label' => esc_html__( 'Sub Heading Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .sec-title-two.style-two .title',
			]
		);
		$this->add_control(
			'Heading-Color',
			[
				'label' => esc_html__( 'Heading Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title-two h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Heading-Typography',
				'label' => esc_html__( 'Heading Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .sec-title-two h2',
			]
		);
		$this->add_control(
			'--Box-Item-Style--',
			[
				'label' => esc_html__( 'Box Item Style', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Title-Color',
			[
				'label' => esc_html__( 'Title Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-info-section .contact-column .upper-box h5' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Title-Typography',
				'label' => esc_html__( 'Title Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .contact-info-section .contact-column .upper-box h5',
			]
		);
		$this->add_control(
			'Content-Color',
			[
				'label' => esc_html__( 'Content Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-info-section .contact-column .upper-box .text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Content-Typography',
				'label' => esc_html__( 'Content Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .contact-info-section .contact-column .upper-box .text',
			]
		);
		$this->add_control(
			'Contact-Info-Color',
			[
				'label' => esc_html__( 'Contact Info Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-info-section .contact-column .lower-box a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'Contact-Info-Typography',
				'label' => esc_html__( 'Contact Info Typography', 'fastrans' ),
				'selector' => '{{WRAPPER}} .contact-info-section .contact-column .lower-box a',
			]
		);
		$this->add_control(
			'Contact-Icon-Color',
			[
				'label' => esc_html__( 'Contact Icon Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-info-section .contact-column .lower-box a .icon' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Contact-Icon-BG-Color',
			[
				'label' => esc_html__( 'Contact Icon BG Color', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-info-section .contact-column .lower-box a .icon' => 'background: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display(); 
        $sub_heading = $settings['sub_heading'];
        $heading     = $settings['heading'];
        $contact_infos = $settings['contact_infos'];
    ?>
    <section class="contact-info-section">
        <div class="auto-container">
            <div class="sec-title-two style-two">
                <div class="title"><?php echo esc_html($sub_heading);?></div>
                <h2><?php echo esc_html($heading);?></h2>
            </div>
            <div class="row clearfix">
                <?php foreach($contact_infos as $info):?>
                <!-- Contact Column -->
                <div class="contact-column col-lg-4 col-md-6 col-sm-12">
                    <div class="inner-column">
                        <div class="upper-box">
                            <h5><?php echo esc_html($info['title']);?></h5>
                            <div class="text"><?php echo esc_html($info['content']);?></div>
                        </div>
                        <div class="lower-box">
                            <a class="phone" href="<?php echo esc_url($info['info_url']);?>"><span class="icon"><?php \Elementor\Icons_Manager::render_icon( $info['info_icon'], [ 'aria-hidden' => 'true' ] ); ?></span><?php echo esc_attr($info['con_info']);?></a>
                        </div>
                    </div>
                </div>
                <?php endforeach;?>
            </div>
        </div>
    </section>
	<?php	
	}

}
