<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Tracking_Number_V7 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tracking_number_v7';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Tracking Number V7', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return ' eicon-gallery-group';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'tracking_section',
				[
					'label' => esc_html__( 'Tracking Number', 'fastrans' ),
				]
		);
        $this->add_control(
            'tracking_number_form',
            [
                'label' => esc_html__( 'Tracking Form Shortcode', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
            ]
        );
        $this->add_control(
            'feature-icon-1',
            [
                'label' => esc_html__( 'Icon 1', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'feature-text-1',
            [
                'label' => esc_html__( 'Feature Text 1', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Affordable Price, Certifcate Fowarders', 'fastrans' ),
            ]
        );
        $this->add_control(
            'feature-icon-2',
            [
                'label' => esc_html__( 'Icon 2', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control(
            'feature-text-2',
            [
                'label' => esc_html__( 'Feature Text 2', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Safe & Reliable Industry Solution!', 'fastrans' ),
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'about_style',
			[
				'label' => esc_html__( 'Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'icon_color_style',
			[
				'label'     => esc_html__( 'Icon Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .feature-block .inner-box .icon' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'text_color',
			[
				'label'     => esc_html__( 'Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .feature-block .inner-box h6' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Text Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .feature-block .inner-box h6',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
            'box_bg',
            [
                'label' => __( 'Content Bg Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'left_bg',
            [
                'label'     => esc_html__( 'Left Bg Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tracking-section .inner-container' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'right_bg',
            [
                'label'     => esc_html__( 'Right Bg Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tracking-section .featured-column .inner-column:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();

	?>

        <!-- Tracking Section -->
        <div class="tracking-section">
            <div class="auto-container">
                <div class="inner-container">
                    <div class="row clearfix">
                        <!-- Tracking Column -->
                        <div class="tracking-column col-lg-7 col-md-12 col-sm-12">
                            <div class="inner-column">
                                <!-- Tracking Form -->
                                <?php echo $settings['tracking_number_form']; ?>
                            </div>
                        </div>
                        <!-- Featured Column -->
                        <div class="featured-column col-lg-5 col-md-12 col-sm-12">
                            <div class="inner-column">
                                <div class="row clearfix">

                                    <!-- Feature Block -->
                                    <div class="feature-block col-lg-6 col-md-6 col-sm-12">
                                        <div class="inner-box">
                                            <div class="icon">
                                                <?php \Elementor\Icons_Manager::render_icon( $settings['feature-icon-1'], [ 'aria-hidden' => 'true' ] ); ?>
                                            </div>
                                            <h6><?php echo $settings['feature-text-1']; ?></h6>
                                        </div>
                                    </div>

                                    <!-- Feature Block -->
                                    <div class="feature-block col-lg-6 col-md-6 col-sm-12">
                                        <div class="inner-box">
                                            <div class="icon">
                                                <?php \Elementor\Icons_Manager::render_icon( $settings['feature-icon-2'], [ 'aria-hidden' => 'true' ] ); ?>
                                            </div>
                                            <h6><?php echo $settings['feature-text-2']; ?></h6>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Tracking Section -->

    <?php 
	
	}

}