<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Steps_Section_V7 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'steps_section_v7';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Steps Section V7', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return ' eicon-form-horizontal';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'steps_section',
				[
					'label' => esc_html__( 'Steps Section', 'fastrans' ),
				]
		);
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__( 'Sub Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'How It Work', 'fastrans' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Easy 1,2, 3 Step To Task', 'fastrans' ),
            ]
        );
        $this->add_control(
            'info',
            [
                'label' => esc_html__( 'Info', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
Tempor incididunt ut labore et dolore magna aliqua.', 'fastrans' ),
            ]
        );
		$this->end_controls_section();

        $this->start_controls_section(
            'steps_icon_section',
            [
                'label' => __( 'Steps Icon', 'fastrans' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );

        $repeater->add_control(
            'icon_title',
            [
                'label' => esc_html__( 'Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Enter Your & Product Details', 'fastrans' ),
            ]
        );
        $repeater->add_control(
            'icon_box_img',
            [
                'label' => esc_html__( 'Icon Outer Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'lists',
            [
                'label' => esc_html__( 'Icon List', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'icon_title' => esc_html__( 'Enter Your & Product Details', 'fastrans' ),
                    ],[
                        'icon_title' => esc_html__( 'Pay Your Service Tag', 'fastrans' ),
                    ],[
                        'icon_title' => esc_html__( 'Ready To Go Your Goods', 'fastrans' ),
                    ],
                ],
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'items_style',
			[
				'label' => esc_html__( 'Item Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'section_bg',
            [
                'label' => esc_html__( 'Section BG', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
		$this->add_control(
			'sub_title_color',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title .title' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'sub_title_typography',
                'label'          => esc_html__( 'Sub Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .sec-title .title',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sec-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .sec-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
        $this->add_control(
            'info_color',
            [
                'label'     => esc_html__( 'Info Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title .text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'info_typography',
                'label'          => esc_html__( 'Info Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .sec-title .text',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
		$this->end_controls_section();
        $this->start_controls_section(
            'section_items_style',
            [
                'label' => __( 'Items Content Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__( 'Icon Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .step-block .inner-box .icon-outer .icon-box' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_content_title',
            [
                'label'     => esc_html__( 'Icon Title Color', 'fastrans' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .step-block .inner-box h5' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'icon_title_typography',
                'label'          => esc_html__( 'Icon Title Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .step-block .inner-box h5',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );

        $this->end_controls_section();

	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();

	?>

        <!-- Steps Section -->
        <div class="steps-section" style="background-image:url(<?php echo $settings['section_bg']['url']; ?>)">
            <div class="auto-container">
                <div class="sec-title centered">
                    <div class="title"><?php echo $settings['sub_title'] ;?></div>
                    <h2><?php echo $settings['title'] ;?></h2>
                    <div class="text"><?php echo $settings['info'] ;?></div>
                </div>
                <div class="inner-container">
                    <div class="row clearfix">

                        <?php
                            foreach ($settings['lists'] as $list):
                        ?>

                        <!-- Step Block -->
                        <div class="step-block col-lg-4 col-md-6 col-sm-12">
                            <div class="inner-box step-section-v7 wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                                <div class="icon-outer">
                                    <div class="icon-box" style="background: url(<?php echo $list['icon_box_img']['url']; ?>)">
                                        <span class="icon">
                                            <?php \Elementor\Icons_Manager::render_icon( $list['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </span>
                                    </div>
                                </div>
                                <h5><?php echo $list['icon_title'] ;?></h5>
                            </div>
                        </div>

                        <?php
                            endforeach;
                        ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Steps Section -->

    <?php 
	
	}

}