<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Team extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_our_team';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Team', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_team',
			[
				'label' => esc_html__( 'Our Team', 'fastrans' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true, 
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your text', 'fastrans' ),
			]
		);
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title', 'fastrans' ),
			]
		);
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'fastrans' ),
					'title'      => esc_html__( 'Title', 'fastrans' ),
					'menu_order' => esc_html__( 'Menu Order', 'fastrans' ),
					'rand'       => esc_html__( 'Random', 'fastrans' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'fastrans' ),
					'ASC'  => esc_html__( 'ASC', 'fastrans' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'fastrans'),
				  'label_block' => true,
				  'options' => get_team_categories()
				]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_1',
			[
				'label' => __( 'Section Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'sub-title-before-border-color',
			[
				'label'     => esc_html__( 'Before Border Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title .sub-title:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Sub-Title-Color',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title .sub-title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Sub-Title-typography',
				'label'          => esc_html__( 'Sub Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title .sub-title',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'Title-Color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Title-typography',
				'label'          => esc_html__( 'Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'Text-Color',
			[
				'label'     => esc_html__( 'Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pera-content p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Text-typography',
				'label'          => esc_html__( 'Text Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .pera-content p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'Button-Color',
			[
				'label'     => esc_html__( 'Button Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-btn a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Button-BG-Color',
			[
				'label'     => esc_html__( 'Button BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-btn a' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Button-typography',
				'label'          => esc_html__( 'Button Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-btn a',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'Button-Hover-Color',
			[
				'label'     => esc_html__( 'Button Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-btn a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Button-Hover-BG-Color',
			[
				'label'     => esc_html__( 'Button Hover BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-btn a:hover' => 'background: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = fastrans_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;

		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-fastrans' );
		$args = array(
			'post_type'      => 'team',
			'posts_per_page' => fastrans_set( $settings, 'query_number' ),
			'orderby'        => fastrans_set( $settings, 'query_orderby' ),
			'order'          => fastrans_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		
		if( fastrans_set( $settings, 'query_category' ) ) $args['team_cat'] = fastrans_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );

		if ( $query->have_posts() ) 
		{ ?>
		
        <!-- Start of Team section
        ============================================= -->
        <section id="ft-team" class="ft-team-section">
            <div class="container">
                <div class="ft-team-content">
                    <div class="row">
                        
                        <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="00ms" data-wow-duration="1500ms">
                            <div class="ft-team-text-area">
                                <?php if( $settings['subtitle'] || $settings['title'] || $settings['text'] ){ ?>
                                <div class="ft-section-title headline pera-content">
                                    <?php if( $settings['subtitle'] ){ ?><span class="sub-title"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
                    				<?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>
                                    <?php if( $settings['text'] ){ ?><p><?php echo wp_kses($settings['text'], true)?> </p><?php } ?>
                                </div>
                                <?php } ?>
                                <?php if($settings['btn_link']['url'] and $settings['btn_title']){ ?>
                                <div class="ft-btn">
                                    <a class="d-flex justify-content-center align-items-center" href="<?php echo esc_url($settings['btn_link']['url'])?>"><?php echo wp_kses($settings['btn_title'], true)?></a>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                        <?php while ( $query->have_posts() ) : $query->the_post(); ?>
                        <div class="col-lg-3 col-md-6 col-sm-6 wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
                            <div class="ft-team-inner-itembox position-relative">
                                <?php if(has_post_thumbnail()){ ?>
                                <span class="hover-shape position-absolute"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/shape/tm-sh.png" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></span>
                                <div class="ft-team-inner-item-img">
                                    <?php the_post_thumbnail('fastrans_270x330'); ?>
                                </div>
                                <?php } ?>
                                <div class="ft-team-inner-item-text headline">
                                    <h3><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'team_link', true));?>"><?php the_title(); ?></a></h3>
                                    <span><?php echo (get_post_meta( get_the_id(), 'designation', true ));?></span>
                                </div>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            </div>
        </section>
    	<!-- End of Team section
        ============================================= -->
                 
        <?php }
		wp_reset_postdata();
	}

}
