<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Skills_V2 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_our_skill_v2';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Skill V2', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}

	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_skill_v2',
			[
				'label' => esc_html__( 'Our Skill V2', 'fastrans' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'fastrans' ),
			]
		);
		$this->add_control(
			'infos',
			[
				'label'       => __( 'Description', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Description', 'fastrans' ),
			]
		);

		$this->add_control(
			'media_img', [
				'label'       => esc_html__( 'Fanfact Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
			]
		);
		$repeater = new Repeater();

		$repeater->add_control(
			'number', [
				'label'       => esc_html__( 'Number', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'symbole', [
				'label'       => esc_html__( 'Symbole', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'fnf_title', [
				'label'       => esc_html__( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'text', [
				'label'       => esc_html__( 'Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'number_color',
			[
				'label'     => esc_html__( 'Number Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}} h1' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'fanfacts_item',
			[
				'label'       => __( 'Add Item', 'fastrans-extension' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ fnf_title }}}',
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'nprogress_number', [
				'label'       => esc_html__( 'Number', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'prog_title', [
				'label'       => esc_html__( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'progress_bar',
			[
				'label'       => __( 'Add Progress Bar Item', 'fastrans-extension' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ prog_title }}}',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'team_heading_style',
			[
				'label' => esc_html__( 'Section Heading Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'marginbtm',
			[
				'label' => __( 'Bottom Space', 'plugin-domain' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .team-section-heading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'sh_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sh_title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-4 h2' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sh_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-4 h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'sh_sub_clr',
			[
				'label'     => esc_html__( 'Sub Heading Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-4 span' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sh_sub_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-4 span',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'content_text_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Text Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sh_text_clr',
			[
				'label'     => esc_html__( 'Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-4 p' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'contb_text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-4 p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'progress_style',
			[
				'label' => esc_html__( 'Progress Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'prog_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'pro_title_color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .progress-item h4' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'pro_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .progress-item h4',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'prom_count_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Count Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'count_clr',
			[
				'label'     => esc_html__( 'Count Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} span.progress-value' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'count_text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} span.progress-value',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$fanfacts_item = $settings['fanfacts_item'];
		?>

        <!-- Skill Section
        ============================================= -->
        <section id="ft-skill-bar" class="ft-skill-section">
			<div class="container">
				<div class="row">
					<div class="col-lg-7">
						<?php if( $settings['subtitle'] || $settings['title'] ){ ?>
						<div class="ft-section-title-4 headline pera-content text-left">
							<?php if( $settings['subtitle'] ){ ?><span class="sub-title"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
							<?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>
							<?php if( $settings['infos'] ){ ?><p><?php echo wp_kses($settings['infos'], true)?></p><?php } ?>
						</div>
						<?php } ?>
						<div class="progress-item">
							<?php foreach($settings['progress_bar'] as $bar):?>
							<div class="progress-single-item">
								<h4><?php echo esc_html($bar['prog_title']);?></h4>
								<div class="progress">
									<div class="progress-bar" role="progressbar" style="width: <?php echo esc_attr($bar['nprogress_number']);?>%;" aria-valuenow="<?php echo esc_attr($bar['nprogress_number']);?>" aria-valuemin="0" aria-valuemax="100"><span class="progress-value"><?php echo esc_attr($bar['nprogress_number']);?>%</span></div>
								</div>
							</div>
							<?php endforeach;?>
						</div>

					</div>
					<div class="col-lg-5 reveal">
						<div class="fan-item-wrap  image-wrap d-flex align-items-end flex-column" style="background-image:url(<?php echo esc_url($settings['media_img']['url']);?>)">
							<?php foreach($fanfacts_item as $item):?>
							<div class="fnf-item elementor-repeater-item-<?php echo esc_attr($item['_id']);?>">
								<h1><span class="odometer" data-count="<?php echo esc_attr($item['number']);?>">00</span><span><?php echo esc_attr($item['symbole']);?></span></h1>
								<h4><?php echo esc_html($item['fnf_title']);?></h4>
								<p><?php echo __($item['text']);?></p>
							</div>
							<?php endforeach;?>
						</div>
					</div>
				</div>
			</div>
        </section>
    	<!-- Skill Section
        ============================================= -->

        <?php
	}

}
