<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
use \Elementor\Group_Control_Background;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Services_V5 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'our_services_v5';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Services V5', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-gallery-justified';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'service_section',
				[
					'label' => esc_html__( 'Services Section', 'fastrans' ),
				]
		);
        $this->add_control(
            'bg_image',
            [
                'label' => esc_html__( 'Background Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        
        $this->add_control(
			'sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'We are Here', 'fastrans' ),
				'placeholder' => esc_html__( 'Type your sub title here', 'fastrans' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Specialist Couriar Services', 'fastrans' ),
				'placeholder' => esc_html__( 'Type your title here', 'fastrans'),
                'label_block' => true,
			]
		);
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'label' => esc_html__( 'Background', 'fastrans' ),
				'types' => [ 'classic' ],
				'selector' => '{{WRAPPER}} .ftn-section-title h2 span::after',
			]
		);

        $this->add_control(
			'content',
			[
				'label' => esc_html__( 'Content', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( ' To be travel management leaders in regions in which we operate, innovative technology to improve the customer experience and bring positive change to the market. ', 'fastrans' ),
				'placeholder' => esc_html__( 'Type your content here', 'fastrans'),
                'label_block' => true,
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'services_list_section',
            [
                'label' => __( 'Services List', 'fastrans' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'service_title',
            [
                'label' => esc_html__( 'Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Direct Drive', 'fastrans' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
			'service_link',
			[
				'label' => esc_html__( 'Link', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'textdomain' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => false,
					'nofollow' => false,
				],
				'label_block' => true,
			]
		);
        
        $repeater->add_control(
            'service_content',
            [
                'label' => esc_html__( 'Content', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'To be travel management leaders in regions in which we operate.', 'fastrans' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'service_icon',
            [
                'label' => esc_html__( 'Service Icon', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        
        
        $repeater->add_control(
            'service_image',
            [
                'label' => esc_html__( 'Service Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__( 'CTA List', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'service_title' => esc_html__( 'Direct Drive', 'fastrans' ),
                        'service_content' => esc_html__( 'To be travel management leaders in regions in which we operate.', 'fastrans' ),
                    ]
                ],
                'title_field' => '{{{ service_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Section Title Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'sub_title_color',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-section-title .sub-title' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'sub_title_typography',
                'label'          => esc_html__( 'Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .ftn-section-title .sub-title',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-section-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_highlight_color',
			[
				'label'     => esc_html__( 'Title Highlight Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-section-title h2 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Sub Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ftn-section-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
        $this->end_controls_section();


        $this->start_controls_section(
			'service_style',
			[
				'label' => esc_html__( 'Service', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			's_title_color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-service-inner-item .ftn-service-text h3' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			's_title_hover_color',
			[
				'label'     => esc_html__( 'Title Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-service-inner-item .ftn-service-text h3:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 's_title_typography',
				'label'          => esc_html__( 'Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ftn-service-inner-item .ftn-service-text h3',
			]
		);
        
		$this->add_control(
			's_content_h',
			[
				'label' => esc_html__( 'Content', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			's_content_color',
			[
				'label'     => esc_html__( 'Content Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-service-inner-item .ftn-service-text p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 's_content_typography',
				'label'          => esc_html__( 'Content Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ftn-service-inner-item .ftn-service-text p',
			]
		);
		$this->add_control(
			's_icon_h',
			[
				'label' => esc_html__( 'Icon', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			's_icon_bg_color',
			[
				'label'     => esc_html__( 'Icon BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-service-inner-item .ftn-service-img-icon .ftn-service-icon' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'button_style',
			[
				'label' => esc_html__( 'Button', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'button_typography',
                'label'          => esc_html__( 'Button Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .ftn-service-content .ftn-service-btn a',
            ]
        );

		
		$this->start_controls_tabs('button_style_tabs');

		//Default style tab start
		$this->start_controls_tab(
		    'btn_style_default',
		    [
		        'label' => esc_html__('Normal', 'fastrans'),
		    ]
		);

		$this->add_control(
		    'button_bg',
		    [
		        'label'     => esc_html__('background Color', 'fastrans'),
		        'type'      => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} .ftn-service-content .ftn-service-btn a' => 'background-color: {{VALUE}};',
		        ],
		        'separator' => 'before',
		    ]
		);
		$this->add_control(
		    'button_default_text_color',
		    [
		        'label'     => esc_html__('Text Color', 'fastrans'),
		        'type'      => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} .ftn-service-content .ftn-service-btn a' => 'color: {{VALUE}};',
		        ],
		        'separator' => 'before',
		    ]
		);

		$this->end_controls_tab();

		//Hover style tab start
		$this->start_controls_tab(
		    'btn_style_hover',
		    [
		        'label' => esc_html__('Hover', 'fastrans'),
		    ]
		);

		$this->add_control(
		    'button_hover_bg',
		    [
		        'label'     => esc_html__('Background Color', 'fastrans'),
		        'type'      => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} .ftn-service-content .ftn-service-btn a:hover' => 'color: {{VALUE}};',
		        ],
		        'separator' => 'before',
		    ]
		);
		$this->add_control(
		    'button_hover_text_color',
		    [
		        'label'     => esc_html__('Text Color', 'fastrans'),
		        'type'      => Controls_Manager::COLOR,
		        'selectors' => [
		            '{{WRAPPER}} .ftn-service-content .ftn-service-btn a:hover' => 'color: {{VALUE}};',
		        ],
		        'separator' => 'before',
		    ]
		);

		$this->end_controls_tabs();
        
        $this->end_controls_section();


	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();

	?>

        <!-- Start Service Section -->
        <section id="ftn-service" class="ftn-service-section position-relative" data-background="<?php echo esc_attr($settings['bg_image']['url']); ?>">
		<div class="container">
			<div class="ftn-section-title text-center headline  wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">

                <?php if(!empty($settings['sub_title'])):?>
                <span class="sub-title text-uppercase"><?php echo esc_html( $settings['sub_title']);?></span>
                <?php endif;?>

                <?php if(!empty($settings['title'])):?>
                <h2><?php echo $settings['title'];?></h2>
                <?php endif;?>
			</div>
			<div class="ftn-service-content">
				<div class="row justify-content-center">

                    <?php foreach ($settings['items'] as $item): ?>
                        <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1000ms">
                            <div class="ftn-service-inner-item position-relative">
                                <div class="ftn-service-text headline pera-content">

                                    <?php if(!empty($item['service_title'])):?>
                                    <h3><a href="<?php echo esc_url($item['service_link']['url']); ?>"><?php echo $item['service_title'];?></a></h3>
                                    <?php endif;?>

                                    <?php if(!empty($item['service_content'])):?>
                                    <p><?php echo esc_html($item['service_content']); ?></p>
                                    <?php endif;?>
                                </div>
                                <div class="ftn-service-img-icon position-relative">

                                    <?php if(!empty($item['service_icon']['url'])): ?>
                                    <div class="ftn-service-icon d-flex align-items-center justify-content-center position-absolute">
                                        <img src="<?php echo esc_url($item['service_icon']['url']); ?>" alt="<?php echo esc_attr($item['service_icon']['alt']);?>">
                                    </div>
                                    <?php endif; ?>

                                    <?php if(!empty($item['service_image']['url'])): ?>
                                    <div class="ftn-service-img">
                                        <img src="<?php echo esc_url($item['service_image']['url']); ?>" alt="<?php echo esc_attr($item['service_image']['alt']);?>">
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
				</div>

                <?php if(!empty($settings['button_text'])): ?>
				<div class="ftn-service-btn text-center  wow fadeInUp" data-wow-delay="700ms" data-wow-duration="1500ms">
					<a href="<?php echo esc_url($settings['button_link']['url']); ?>"><?php echo esc_html($settings['button_text']); ?></a>
				</div>
                <?php endif; ?>
			</div>
		</div>
	</section>
        <!-- End Service Section -->

    <?php 
	
	}

}