<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Projects_V4 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_our_projects_v4';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Projects V4', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_projects_v4',
			[
				'label' => esc_html__( 'Our Projects V4', 'fastrans' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
				'default'     => __( 'Projects', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'number',
			[
				'label'   => esc_html__( 'Number of post', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'cat_exclude',
			[
				'label'       => esc_html__( 'Exclude', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'Exclude categories, etc. by ID with comma separated.', 'fastrans' ),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'fastrans' ),
					'ASC'  => esc_html__( 'ASC', 'fastrans' ),
				),
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'fastrans' ),
					'title'      => esc_html__( 'Title', 'fastrans' ),
					'menu_order' => esc_html__( 'Menu Order', 'fastrans' ),
					'rand'       => esc_html__( 'Random', 'fastrans' ),
				),
			]
		);
		$this->add_control(
            'show_pagination',
			[
				'label' => __( 'Enable/Disable Pagination', 'fastrans' ),
				'type'     => Controls_Manager::SWITCHER,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enable/Disable Pagination', 'fastrans' ),
			]
		);
		$this->end_controls_section();
		
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');
		
		$paged = get_query_var('paged');
		$paged = fastrans_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;
		
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-fastrans' );
		$args = array(
			'post_type'      => 'project',
			'posts_per_page' => fastrans_set( $settings, 'number' ),
			'orderby'        => fastrans_set( $settings, 'query_orderby' ),
			'order'          => fastrans_set( $settings, 'query_order' ),
			'paged'         => $paged
		);
		$terms_array = explode(",",fastrans_set( $settings, 'cat_exclude' ));
		if(fastrans_set( $settings, 'cat_exclude' )) $args['tax_query'] = array(array('taxonomy' => 'project_cat','field' => 'id','terms' => $terms_array,'operator' => 'NOT IN',));
		$allowed_tags = wp_kses_allowed_html('post');
		$query = new \WP_Query( $args );
		$t = '';
		$data_filtration = '';
		$data_posts = '';
		if ( $query->have_posts() ) 
		{
		ob_start();
		?>
  
		<?php 
            $count = 0; 
            $fliteration = array();
            while( $query->have_posts() ): $query->the_post();
            global  $post;
            $meta = '';
            $meta1 = ''; 
            $post_terms = get_the_terms( get_the_id(), 'project_cat');
            foreach( (array)$post_terms as $pos_term ) $fliteration[$pos_term->term_id] = $pos_term;
            $temp_category = get_the_term_list(get_the_id(), 'project_cat', '', ', ');
            
            $post_terms = wp_get_post_terms( get_the_id(), 'project_cat'); 
            $term_slug = '';
            if( $post_terms ) foreach( $post_terms as $p_term ) $term_slug .= $p_term->slug.' ';
        	
			$term_list = wp_get_post_terms(get_the_id(), 'project_cat', array("fields" => "names"));
			$post_thumbnail_id = get_post_thumbnail_id($post->ID);
			$post_thumbnail_url = wp_get_attachment_url( $post_thumbnail_id );
			
            ?>
            
            <div class="col-lg-4 col-sm-6 filtr-item mix all <?php echo esc_attr($term_slug); ?>" data-sort="<?php echo esc_attr($term_slug); ?>">
                <div class="ft-portfolio-slider-innerbox position-relative">
                    <?php if(has_post_thumbnail()){ ?>
                    <div class="ft-project-img">
                        <?php the_post_thumbnail('fastrans_473x500'); ?>
                    </div>
                    <?php } ?>
                    <div class="ft-portfolio-text headline headline pera-content">
                        <h3><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'project_url', true ));?>"><?php the_title(); ?></a></h3>
                        <p><?php echo wp_kses(fastrans_trim(get_the_content(), $settings['text_limit']), true); ?> </p>
                        <div class="ft-btn-3">
                            <a class="d-flex justify-content-center align-items-center" href="<?php echo esc_url(get_post_meta( get_the_id(), 'project_url', true ));?>"><?php esc_html_e('Read More', 'fastrans')?> <i class="flaticon-right-arrow"></i></a>
                        </div>
                    </div>
                </div>
            </div>    
            
			<?php endwhile;?>

            <?php wp_reset_postdata();
            $data_posts = ob_get_contents();
            ob_end_clean();
            
            ob_start();?>
            
            <?php $terms = get_terms(array('project_cat')); ?>
			
            <!-- Start of Project section
            ============================================= -->
            <section id="ft-project-page" class="ft-project-page-section page-padding">
                <div class="container">
                    <?php if($settings['subtitle'] || $settings['title']){ ?>
                    <div class="ft-section-title-2 headline pera-content text-center">
                        <?php if($settings['subtitle']){ ?><span class="sub-title"><?php echo wp_kses($settings['subtitle'], true);?></span><?php } ?>
                        <?php if($settings['title']){ ?><h2><?php echo wp_kses($settings['title'], true);?></h2><?php } ?>
                    </div>
                    <?php } ?>
                    <div class="ft-project-post-item-content">
                        <!-- MixitUp Gallery -->
                        <div class="mixitup-gallery">
                            
                            <!-- Filter -->
                            <div class="filters ft-project-item-filter-btn ul-li">
                                <ul id="filters" class="filter-tabs filter-btns clearfix nav-gallery text-center">
                                    <li class=" active filter filtr-button active" data-role="button" data-filter="all"><?php esc_attr_e('All', 'fastrans');?></li>
                                    <?php foreach( $fliteration as $t ): ?>
                                    <li class="filter filtr-button"  data-role="button" data-filter=".<?php echo esc_attr(fastrans_set( $t, 'slug' )); ?>"><?php echo fastrans_set( $t, 'name'); ?> </li>
                                    <?php endforeach;?>
                                </ul>
                            </div>
                
                            <div class="filter-list ft-project-item-wrapper filtr-container row clearfix">
                                <?php echo wp_kses($data_posts, true); ?>
                            </div>
							
							
                    	</div>
                    </div>
                    
                    <?php if($settings['show_pagination']){ ?>
                    <div class="ft-pagination-item text-center ul-li">
                        <?php fastrans_the_pagination2(array('total'=>$query->max_num_pages, 'next_text' => '<i class="fa fa-angle-double-right"></i> ', 'prev_text' => '<i class="fa fa-angle-double-left"></i>')); ?>
                    </div>
                    <?php } ?>
                    
                </div>
            </section>
        	<!-- End of Project section
            ============================================= -->
            
       <?php }
	}

}
