<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Projects extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_our_projects';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Projects', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_projects',
				[
					'label' => esc_html__( 'Our Projects', 'fastrans' ),
				]
		);
		$this->add_control(
			'text_limit',
			[
				'label'   => esc_html__( 'Text Limit', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_number',
			[
				'label'   => esc_html__( 'Number of post', 'fastrans' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 4,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
			]
		);
		$this->add_control(
			'query_orderby',
			[
				'label'   => esc_html__( 'Order By', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => array(
					'date'       => esc_html__( 'Date', 'fastrans' ),
					'title'      => esc_html__( 'Title', 'fastrans' ),
					'menu_order' => esc_html__( 'Menu Order', 'fastrans' ),
					'rand'       => esc_html__( 'Random', 'fastrans' ),
				),
			]
		);
		$this->add_control(
			'query_order',
			[
				'label'   => esc_html__( 'Order', 'fastrans' ),
				'label_block' => true,
				'type'    => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => array(
					'DESC' => esc_html__( 'DESC', 'fastrans' ),
					'ASC'  => esc_html__( 'ASC', 'fastrans' ),
				),
			]
		);
		$this->add_control(
            'query_category', 
				[
				  'type' => Controls_Manager::SELECT,
				  'label' => esc_html__('Category', 'fastrans'),
				  'label_block' => true,
				  'options' => get_project_categories()
				]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'projects_style',
			[
				'label' => esc_html__( 'Project Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'number_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Number Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'number_clr',
			[
				'label'     => esc_html__( 'Number Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-case-study-items .ft-case-study-text .serial-no' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'numbere_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-case-study-items .ft-case-study-text .serial-no',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-case-study-items .ft-case-study-text h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-case-study-items .ft-case-study-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'text_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Text Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'text_clr',
			[
				'label'     => esc_html__( 'Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-case-study-items .ft-case-study-text p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-case-study-items .ft-case-study-text p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}
	
	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		
        $paged = get_query_var('paged');
		$paged = fastrans_set($_REQUEST, 'paged') ? esc_attr($_REQUEST['paged']) : $paged;
		
		$this->add_render_attribute( 'wrapper', 'class', 'templatepath-fastrans' );
		$args = array(
			'post_type'      => 'project',
			'posts_per_page' => fastrans_set( $settings, 'query_number' ),
			'orderby'        => fastrans_set( $settings, 'query_orderby' ),
			'order'          => fastrans_set( $settings, 'query_order' ),
			'paged'          => $paged
		);
		
		if( fastrans_set( $settings, 'query_category' ) ) $args['project_cat'] = fastrans_set( $settings, 'query_category' );
		$query = new \WP_Query( $args );
		
		if ( $query->have_posts() ) 
		{ ?>
		
        <!-- Start of Case Study section
        ============================================= -->
        <section id="ft-case-study" class="ft-case-study-section">
            <div class="ft-case-study-content d-flex">
                <?php $i = 1; while ( $query->have_posts() ) : $query->the_post(); ?>
                <div class="ft-case-study-items position-relative">
                    <?php if(has_post_thumbnail()){ ?>
                    <div class="ft-case-study-img position-relative">
                        <?php the_post_thumbnail('fastrans_480x700'); ?>
                    </div>
                    <?php } ?>
                    <div class="ft-case-study-text headline pera-content">
                        <span class="serial-no"><?php $i = sprintf('%02d', $i); echo $i; ?></span>
                        <h3><a href="<?php echo esc_url(get_post_meta( get_the_id(), 'project_url', true ));?>"><?php the_title(); ?></a></h3>
                        <p><?php echo wp_kses(fastrans_trim(get_the_content(), $settings['text_limit']), true); ?> </p>
                    </div>
                    <a class="more-btn d-flex align-items-center justify-content-center" href="<?php echo esc_url(get_post_meta( get_the_id(), 'project_url', true ));?>"><i class="fas fa-arrow-right"></i></a>
                </div>
                <?php $i++; endwhile; ?>
            </div>
        </section>
    	<!-- End of Case Study section
        ============================================= -->
              	
		<?php }
		wp_reset_postdata();
	}
}