<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Our_Awesome_Service extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_our_awesome_service';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Our Awesome Service', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_testimonials_v3',
			[
				'label' => esc_html__( 'Our Testimonials V3', 'fastrans' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true, 
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description Here', 'fastrans' ),
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'list_title',
			[
				'label'       => __( 'List Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
		$repeater->add_control(
			'list_info',
			[
				'label'       => __( 'List Info', 'fastrans' ),
				'type'        => Controls_Manager::WYSIWYG,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
		$this->add_control(
            'listsinfos',
            [
                'label'       => __( 'Add Item', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );
		
		$this->add_control(
			'shape_img',
			[
				'label'       => __( 'Shape Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
        
		$repeater = new Repeater();
       
		$repeater->add_control(
			'service_img',
			[
				'label'       => __( 'Service Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
        $this->add_control(
            'sliders',
            [
                'label'       => __( 'Add Item', 'fastrans' ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );
		
		$this->end_controls_section();
		$this->start_controls_section(
			'aw_service_style',
			[
				'label' => esc_html__( 'Content Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'subtitle_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Sub Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sbtitle_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-5 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sbtitle_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-5 span',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'se_main_ttl_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'main_title_clr',
			[
				'label'     => esc_html__( 'Main Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-5 h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'main_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-5 h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'text_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Text Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'text_clr',
			[
				'label'     => esc_html__( 'Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-5 p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-5 p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'list_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'List Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'list_title_clr',
			[
				'label'     => esc_html__( 'List Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fa-aw-list-items h4' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'btn_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .fa-aw-list-items h4',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'list_itme_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'List Item Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'list_item_clr',
			[
				'label'     => esc_html__( 'List Item Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .fa-aw-list-items ul li' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'ls_itm_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .fa-aw-list-items ul li',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display(); ?>
		
        <!-- Start of Testimonial section
        ============================================= -->
        <section id="ft-awesome-service" class="ft-awesome-service">
            <div class="container">                
                <div class="row align-items-end">
                    <div class="col-lg-7 col-md-5">
                        <div class="ft-awesome-content">
                        <?php if( $settings['subtitle'] || $settings['title'] ){ ?>
                        <div class="ft-section-title-5">
                            <?php if( $settings['subtitle'] ){ ?><span class="sub-title"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
                            <?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>							
							<?php if( $settings['text'] ){ ?>
								<p><?php echo wp_kses($settings['text'], true)?></p>
							<?php } ?>
                        </div>
                        <?php } ?>
						<div class="fs-aw-list-item">
							<div class="row">
								<?php foreach($settings['listsinfos'] as $list):?>
								<div class="col-lg-6">
									<div class="fa-aw-list-items">
										<h4><?php echo esc_html($list['list_title']);?></h4>
										<?php echo __($list['list_info']);?>
									</div>
								</div>
								<?php endforeach;?>		
							</div>					
						</div>
                    </div>
                    </div>
                    <div class="col-lg-5 col-md-5">
                        <div class="fs-awesome-slide-wrap position-relative">							
							<div class="shape-img">
								<img src="<?php echo esc_url($settings['shape_img']['url']);?>" alt="">
							</div>
							<div class="fs-awesome-slide reveal">
								<?php foreach($settings['sliders'] as $item):?>
								<div class="fs-awesome-slide-item image-wrap">
									<img src="<?php echo esc_url($item['service_img']['url']);?>" alt="">
								</div>
								<?php endforeach;?>							
							</div>
						</div>
                    </div>
                </div>
            </div>
        </section>
    	<!-- End of Testimonial section
        ============================================= -->
        
        <?php 
	}
}