<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Logistic_Testimonial extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_logistic_testimonials';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Logistic Testimonials', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_testimonials_v5',
			[
				'label' => esc_html__( 'Logistic Testimonials', 'fastrans' ),
			]
		);
        
		$this->add_control(
			'section_img',
			[
				'label'       => __( 'Section BG Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
		$this->add_control(
			'shape_img',
			[
				'label'       => __( 'Shape Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
        $this->add_control(
			'section_title',
			[
				'label'       => __( 'Section Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
		$repeater = new Repeater();
        
        $repeater->add_control(
			'feedback',
			[
				'label'       => __( 'Feedback', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
        $repeater->add_control(
			'name',
			[
				'label'       => __( 'Name', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
        $repeater->add_control(
			'position',
			[
				'label'       => __( 'Position', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
			]
		);
        $this->add_control(
            'testimonials',
            [
                'label'       => __( 'Add Item', 'fastrans' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
            ]
        );
		$this->end_controls_section();
        $this->start_controls_section(
			'aw_service_style',
			[
				'label' => esc_html__( 'Content Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'feedback_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Feedback Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
        $this->add_control(
			'hd_title_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'banner_title_cl',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-section-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'sec_bg_title_cl',
			[
				'label'     => esc_html__( 'Title Shape Background Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-section-title h2:before, .tl-thx-section-title h2:after, .tl-thx-section-title h2 i' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'serv_sec_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-section-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'feedback_clr',
			[
				'label'     => esc_html__( 'Feedback Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-testimonial-item-wrap p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'feedback_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-testimonial-item-wrap p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'name_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Name Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'name_clr',
			[
				'label'     => esc_html__( 'Name Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-testimonial-item-wrap .tl-thx-testimonial-author h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'name_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-testimonial-item-wrap .tl-thx-testimonial-author h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'postition_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Position  Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'post_clr',
			[
				'label'     => esc_html__( 'Position Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-testimonial-item-wrap .tl-thx-testimonial-author span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'pos__typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-testimonial-item-wrap .tl-thx-testimonial-author span',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'arrow_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Arrow Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'arrwo_cl',
			[
				'label'     => esc_html__( 'Arrow  Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-testimonial-content .carousel_nav button' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'arrwo_bg_cl',
			[
				'label'     => esc_html__( 'Arrow BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-testimonial-content .carousel_nav button' => 'background-color: {{VALUE}}',
				],
			]
		);
		
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
           $testimonials =  $settings['testimonials'];
        ?>
		
        <!-- Start of Testimonial section
        ============================================= -->
        <section id="tl-thx-testimonial" class="tl-thx-testimonial-section" data-background="<?php echo esc_url($settings['section_img']['url']);?>">
            <div class="container">
                <div class="tl-thx-testimonial-content position-relative">
                    <span class="testimonial-shape1 position-absolute"><img src="<?php echo esc_url($settings['shape_img']['url']);?>"></span>
                    <div class="tl-thx-section-title headline pera-content text-center">
                        <h2><i></i><?php echo wp_kses( $settings['section_title'], true );?></h2>
                    </div>
                    <div class="tl-thx-testimonial-slider">
                        <?php foreach($settings['testimonials'] as $item):?>
                        <div class="tl-thx-testimonial-item pera-content text-center headline">
                            <div class="tl-thx-testimonial-item-wrap">
                                <p>
                                    <?php echo wp_kses( $item['feedback'], true );?>
                                </p>
                                <div class="tl-thx-testimonial-author">
                                    <h3><?php echo wp_kses( $item['name'], true );?></h3>
                                    <span><?php echo wp_kses( $item['position'], true );?></span>
                                </div>
                            </div>
                        </div>
                        <?php endforeach;?>
                    </div>
                    <div class="carousel_nav  clearfix">
                        <button type="button" class="testi-left_arrow"><i class="far fa-long-arrow-left"></i></button>
                        <button type="button" class="testi-right_arrow"><i class="far fa-long-arrow-right"></i></button>
                    </div>
                </div>
            </div>
        </section>
    <!-- End of Testimonial section
        ============================================= -->
        
        <?php
	}
}