<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Logistic_Team extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_logistic_team';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Logistic Team', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'our_team_v4',
			[
				'label' => esc_html__( 'Our Team', 'fastrans' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title_info',
			[
				'label'       => __( 'Description', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Enter your Description', 'fastrans' ),
			]
		);
		$this->add_control(
			'btn_label', [
				'label'       => esc_html__( 'Button Label', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'btn_link',
			[
				'label' => __( 'Link', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'fastrans' ),
			]
		);
		$repeater = new Repeater();
		
		$repeater->add_control(
			'team_img', [
				'label'       => esc_html__( 'Team Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'item_id', [
				'label'       => esc_html__( 'ID', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'team_name', [
				'label'       => esc_html__( 'Team Member Name', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'designation', [
				'label'       => esc_html__( 'Designation', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
			]
		);
		
		$repeater->add_control(
			'team_link',
			[
				'label' => __( 'Link', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'fastrans' ),
			]
		);
		$repeater->add_control(
			'social_1',
			[
				'label' => __( 'Social Profile 1', 'fastrans' ),
				'type' => Controls_Manager::ICONS,
			]
		);
		$repeater->add_control(
			'profile_1_link',
			[
				'label' => __( 'Profile 1 Link', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'fastrans' ),
			]
		);
		$repeater->add_control(
			'social_2',
			[
				'label' => __( 'Social Profile 2', 'fastrans' ),
				'type' => Controls_Manager::ICONS,
			]
		);
		$repeater->add_control(
			'profile_2_link',
			[
				'label' => __( 'Profile 2 Link', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'fastrans' ),
			]
		);
		$repeater->add_control(
			'social_3',
			[
				'label' => __( 'Social Profile 3', 'fastrans' ),
				'type' => Controls_Manager::ICONS,
			]
		);
		$repeater->add_control(
			'profile_3_link',
			[
				'label' => __( 'Profile 3 Link', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'fastrans' ),
			]
		);
		$repeater->add_control(
			'social_4',
			[
				'label' => __( 'Social Profile 3', 'fastrans' ),
				'type' => Controls_Manager::ICONS,
			]
		);
		$repeater->add_control(
			'profile_4_link',
			[
				'label' => __( 'Profile 4 Link', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'fastrans' ),
			]
		);
		$this->add_control(
			'teams',
			[
				'label'       => __( 'Add Item', 'fastrans-extension' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ team_name }}}',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'team_heading_style',
			[
				'label' => esc_html__( 'Section Heading Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'hd_title_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'banner_title_cl',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-section-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'sec_bg_title_cl',
			[
				'label'     => esc_html__( 'Title Shape Background Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-section-title h2:before, .tl-thx-section-title h2:after, .tl-thx-section-title h2 i' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'serv_sec_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-section-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'banner_desc_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Description Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sec_desc_cl',
			[
				'label'     => esc_html__( 'Section Description Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pera-content p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sec_desc_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .pera-content p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
        $this->add_control(
			'btn_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Button Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'btn_cl',
			[
				'label'     => esc_html__( 'Button Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-btn a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'btn_bg_cl',
			[
				'label'     => esc_html__( 'Button BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-btn a' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'btn_tpl_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-btn a',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
        $this->add_control(
			'team_title_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Team Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'tm_title_cl',
			[
				'label'     => esc_html__( 'Team Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-team-inner-item .tl-thx-team-text h3' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'tm_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-team-inner-item .tl-thx-team-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
        $this->add_control(
			'team_design_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Team Designation Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'tm_desig_cl',
			[
				'label'     => esc_html__( 'Team Designation Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-team-inner-item .tl-thx-team-text p' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'tm_desig_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-team-inner-item .tl-thx-team-text p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
        $this->add_control(
			'team_icon_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Team Icon Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'tm_icon_cl',
			[
				'label'     => esc_html__( 'Team Designation Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-team-inner-item .tl-thx-team-img-social-wrapper .tl-thx-team-social a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'tm_icon_hv_cl',
			[
				'label'     => esc_html__( 'Team Icon Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-team-inner-item .tl-thx-team-img-social-wrapper .tl-thx-team-social a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'team_box_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Team Box Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'box-overlay-background',
				'label' => esc_html__( 'Background', 'fastrans' ),
				'types' => [ 'gradient' ],
				'selector' => '{{WRAPPER}} .tl-thx-team-inner-item .tl-thx-team-img-social-wrapper .tl-thx-team-img:before',
			]
		);
		$this->add_control(
			'box_border_cl',
			[
				'label'     => esc_html__( 'Box Border Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-team-inner-item:before' => 'border-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$teams = $settings['teams'];
		?>
		<!-- Start of Team section
        ============================================= -->
        <section id="tl-thx-team" class="tl-thx-team-section">
            <div class="container">
                <div class="tl-thx-team-top-content d-flex  justify-content-between">
                    <div class="tl-thx-section-title headline text-left pera-content  wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                        <h2><i></i><?php echo wp_kses( $settings['title'], true );?></h2>
                    </div>
                    <div class="tl-thx-team-top-text-btn pera-content  wow fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <p><?php echo wp_kses( $settings['title_info'], true );?></p>
                        <div class="tl-thx-btn d-flex justify-content-end">
                            <a class="d-flex justify-content-center align-items-center text-uppercase" href="<?php echo esc_url($settings['btn_link']['url']);?>"><?php echo wp_kses( $settings['btn_label'], true );?> <i class="far fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
                <div class="tl-thx-team-content">
                    <div class="row">
                        <?php foreach($settings['teams'] as $item):?>
                        <div class="col-lg-3 col-md-6  wow fadeInUp" data-wow-delay="800ms" data-wow-duration="1500ms">
                            <div class="tl-thx-team-inner-item text-center position-relative">
                                <div class="tl-thx-team-img-social-wrapper position-relative">
                                    <div class="tl-thx-team-img position-relative">
                                        <img src="<?php echo esc_url($item['team_img']['url']);?>">
                                    </div>
                                    <div class="tl-thx-team-social">

                                        <?php if(!empty($item['social_1'])):?>
                                        <a href="<?php echo esc_url($settings['profile_1_link']['url']);?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $item['social_1'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </a>
                                        <?php endif;?> 

                                        <?php if(!empty($item['social_2'])):?>
                                        <a href="<?php echo esc_url($settings['profile_2_link']['url']);?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $item['social_2'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </a>
                                        <?php endif;?> 

                                        <?php if(!empty($item['social_3'])):?>
                                        <a href="<?php echo esc_url($settings['profile_3_link']['url']);?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $item['social_3'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </a>
                                        <?php endif;?> 

                                        <?php if(!empty($item['social_4'])):?>
                                        <a href="<?php echo esc_url($settings['profile_4_link']['url']);?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $item['social_4'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </a>
                                        <?php endif;?> 
                                           

                                    </div>
                                </div>
                                <div class="tl-thx-team-text headline pera-content">
                                    <h3><a href="<?php echo esc_url($item['team_link']['url']);?>"><?php echo esc_html($item['team_name']);?></a></h3>
                                    <p><?php echo esc_html($item['designation']);?></p>
                                </div>
                            </div>
                        </div>
                        <?php endforeach;?>
                    </div>
                </div>
            </div>
        </section>
        <!-- End of Team section
        ============================================= -->
        
                         
        <?php
	}

}
