<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Logistic_Service extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrance_trans_logi_service';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Logistic Service', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}

	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'transport_service',
			[
				'label' => esc_html__( 'Service Option', 'fastrans' ),
			]
		);

		$this->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label'       => esc_html__( 'Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'more_text_label', [
				'label'       => esc_html__( 'More Text Label', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'btn_label', [
				'label'       => esc_html__( 'Button Label', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'btn_link',
			[
				'label' => __( 'Link', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'fastrans' ),
			]
		);

		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'service_id', [
                'label'       => esc_html__( 'Select portfolio', 'fastrans' ),
                'type'        => Controls_Manager::SELECT,
                'label_block' => true,
                'options'     => $this->select_param_posts(),
            ]
        );

        $repeater->add_control(
			'service_icon',
			[
				'label' => esc_html__( 'Service Icon', 'fastrans' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'service_img',
			[
				'label' => esc_html__( 'Service Img', 'fastrans' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

        $repeater->add_control(
			'description',
			[
				'label' => esc_html__( 'Description', 'fastrans' ),
				'type' => Controls_Manager::WYSIWYG,
				'default' => esc_html__( 'Contrary to popular belief is not simply random text velit.', 'fastrans' ),
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'custom_link',
			[
				'label' => esc_html__( 'Link', 'fastrans' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

        $this->add_control(
			'serviceitem',
			[
				'label' => esc_html__( 'Service List', 'fastrans' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		// select columns
		$this->add_responsive_control(
			'columns',
			[
				'label' => __( 'Columns', 'fastrans' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'2' => __( '2 Columns', 'fastrans' ),
					'3' => __( '3 Columns', 'fastrans' ),
					'4' => __( '4 Columns', 'fastrans' ),
				],
				'default' => '4',
				'toggle' => true,
			]
		);



		$this->end_controls_section();

        $this->start_controls_section(
			'service_infos_st',
			[
				'label' => esc_html__( 'Servioce Info Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'hd_title_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'banner_title_cl',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-section-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'sec_bg_title_cl',
			[
				'label'     => esc_html__( 'Title Shape Background Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-section-title h2:before, .tl-thx-section-title h2:after, .tl-thx-section-title h2 i' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'serv_sec_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-section-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'banner_desc_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Description Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sec_desc_cl',
			[
				'label'     => esc_html__( 'Section Description Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-section-title p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sec_desc_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-section-title p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'service_titll_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Service Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'serv_title_cl',
			[
				'label'     => esc_html__( 'Service Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-service-inner-item h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'ser_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-service-inner-item h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'service_desc_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Service Desc Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'serv_desc_cl',
			[
				'label'     => esc_html__( 'Service Desc Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-service-inner-item p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'ser_desc_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-service-inner-item p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'service_icon_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Service Icon, Link Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'serv_icon_cl',
			[
				'label'     => esc_html__( 'Icon Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-service-inner-item .tl-thx-service-icon i' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'serv_link_cl',
			[
				'label'     => esc_html__( 'Link Btn Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-service-inner-item .tl-thx-service-btn a' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'service_box_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Service Box Style', 'fastrans' ),
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'box-overlay-background',
				'label' => esc_html__( 'Background', 'fastrans' ),
				'types' => [ 'gradient' ],
				'selector' => '{{WRAPPER}} .tl-thx-service-inner-item .tl-thx-service-img-wrapper:after',
			]
		);
		$this->add_control(
			'box_border_cl',
			[
				'label'     => esc_html__( 'Box Border Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-service-inner-item:before' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
    ?>
        <!-- Start of Service section
        ============================================= -->
        <section id="tl-thx-service" class="tl-thx-service-section">
            <div class="container">
                <div class="tl-thx-section-title headline pera-content text-center  wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
                    <h2><i></i><?php echo wp_kses( $settings['title'], true )?></h2>
                    <p><?php echo wp_kses( $settings['description'], true )?></p>
                </div>
                <div class="tl-thx-service-content">
                    <div class="row">
                    <?php $shape = 0; foreach($settings['serviceitem'] as $index => $box): $shape++;
						if($settings['columns'] == 2)
							$col = 'col-lg-6 col-md-6';
						elseif($settings['columns'] == 3)
							$col = 'col-lg-4 col-md-6';
						elseif($settings['columns'] == 4)
							$col = 'col-lg-3 col-md-6';
						else
							$col = 'col-lg-3 col-md-6';

					?>
                    <?php  if( $box['service_id'] ) : ?>
                        <div class="<?php echo esc_attr($col); ?> wow fadeInUp" data-wow-delay="800ms" data-wow-duration="1500ms">
                            <div class="tl-thx-service-inner-item position-relative">
                                <div class="tl-thx-service-img-wrapper position-relative">
                                    <div class="tl-thx-service-img">
                                        <?php if(!empty($box['service_img']['url'])):?>
                                        <img class="w-100" src="<?php echo esc_url($box['service_img']['url']) ;?>" alt="">
                                        <?php else:?>
                                        <img class="w-100" src="<?php echo get_the_post_thumbnail_url($box['service_id'], 'large');?>" alt="">
                                        <?php endif;?>
                                    </div>
                                    <div class="tl-thx-service-text-icon">
                                        <div class="tl-thx-service-icon">
                                            <?php \Elementor\Icons_Manager::render_icon( $box['service_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </div>
                                        <div class="tl-thx-service-text headline pera-content">
                                            <h3><a href="<?php if(!empty($box['custom_link']['url'])){echo esc_url($box['custom_link']['url']);} else{echo get_the_permalink($box['service_id']);}?>"><?php echo get_the_title($box['service_id']);?></a></h3>
                                            <p><?php echo wp_kses($box['description'], true);?></p>
                                            <div class="tl-thx-service-btn d-flex justify-content-end">
                                                <a class="d-flex justify-content-center align-items-center" href="<?php if(!empty($box['custom_link']['url'])){echo esc_url($box['custom_link']['url']);} else{echo get_the_permalink($box['service_id']);}?>"><i class="far fa-arrow-right"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; endforeach;?>
                    </div>
                    <div class="tl-thx-service-more text-center  wow fadeInUp" data-wow-delay="600ms" data-wow-duration="1500ms">
                        <span><?php echo wp_kses( $settings['more_text_label'], true )?> <a href="<?php echo esc_url($settings['btn_link']['url']);?>"><?php echo wp_kses( $settings['btn_label'], true )?></a></span>
                    </div>
                </div>
            </div>
        </section>
    <!-- End of Service section
        ============================================= -->
	<?php
	}
    protected function select_param_posts() {
        $args = wp_parse_args( [
            'post_type'   => 'service',
            'numberposts' => -1,
            'orderby'     => 'title',
            'order'       => 'ASC',
        ] );

        $query_query = get_posts( $args );

        $posts = [];
        if ( $query_query ) {
            foreach ( $query_query as $query ) {
                $posts[$query->ID] = $query->post_title;
            }
        }

        return $posts;
    }
}
