<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Logistic_Banner extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrance_trans_logi_banner';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Logistic Hero Banner', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'transport_slider',
			[
				'label' => esc_html__( 'Banner Option', 'fastrans' ),
			]
		);
		
		$this->add_control(
			'slider_bg_img', [
				'label'       => esc_html__( 'Background Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'bg_shape_1', [
				'label'       => esc_html__( 'Shape Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'bg_shape_2', [
				'label'       => esc_html__( 'Shape 2 Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'bg_shape_3', [
				'label'       => esc_html__( 'Shape 3 Image', 'fastrans' ),
				'type'        => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label'       => esc_html__( 'Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'btn_label', [
				'label'       => esc_html__( 'Button Label', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		
		$this->add_control(
			'btn_link',
			[
				'label' => __( 'Link', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'fastrans' ),
			]
		);
		
		$this->end_controls_section();
        $this->start_controls_section(
			'slider_banner_style',
			[
				'label' => esc_html__( 'Banner Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'banner_title_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Bannner Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'banner_title_cl',
			[
				'label'     => esc_html__( 'Banner Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-banner-text h1' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'banner_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-banner-text h1',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'banner_desc_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Description Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'banner_desc_cl',
			[
				'label'     => esc_html__( 'Banner Description Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-banner-text p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'banner_desc_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-banner-text p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'btn_st',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Button Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'btn_cl',
			[
				'label'     => esc_html__( 'Button Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-btn a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'btn_bg_cl',
			[
				'label'     => esc_html__( 'Button BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tl-thx-btn a' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'btn_tpl_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .tl-thx-btn a',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display(); 
    ?>
        <!-- Start of Slider section
        ============================================= -->
        <section id="tl-thx-banner" class="tl-thx-banner-section position-relative"  data-background="<?php echo esc_url($settings['slider_bg_img']['url']);?>">
            <div class="tl-thx-banner-img position-absolute"><img src="<?php echo esc_url($settings['bg_shape_1']['url']);?>"></div>
            <div class="tl-thx-banner-img2 position-absolute"><img src="<?php echo esc_url($settings['bg_shape_2']['url']);?>"></div>
            <div class="tl-thx-banner-img3 position-absolute"><img src="<?php echo esc_url($settings['bg_shape_3']['url']);?>"></div>
            <div class="container">
                <div class="tl-thx-banner-text text-center position-relative headline pera-content">
                    <h1><?php echo wp_kses( $settings['title'], true );?></h1>
                    <p><?php echo wp_kses( $settings['description'], true );?></p>
                    <div class="tl-thx-btn d-flex justify-content-center">
                        <a class="d-flex justify-content-center align-items-center text-uppercase" href="<?php echo esc_url($settings['btn_link']['url']);?>"><?php echo wp_kses( $settings['btn_label'], true );?> <i class="far fa-arrow-right"></i></a>
                    </div>
                </div>
            </div>
        </section>	
    <!-- End of Slider section
        ============================================= -->
	<?php	
	}

}
