<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Language_V7 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'language_v7';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Language V7', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return ' eicon-form-horizontal';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'language_section',
				[
					'label' => esc_html__( 'Language Section', 'fastrans' ),
				]
		);
        $this->add_control(
            'language_flag_img',
            [
                'label' => esc_html__( 'Country Image', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'language_text',
            [
                'label' => esc_html__( 'Language Name', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Eng', 'fastrans' ),
            ]
        );
		$this->end_controls_section();

        $this->start_controls_section(
            'feature_box_section',
            [
                'label' => __( 'Language Select', 'fastrans' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'language_dropdown_text',
            [
                'label' => esc_html__( 'Language Name', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'English', 'fastrans' ),
            ]
        );
        $this->add_control(
            'items',
            [
                'label' => esc_html__( 'Item List', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'language_dropdown_text' => esc_html__( 'English', 'fastrans' ),
                    ],[
                        'language_dropdown_text' => esc_html__( 'France', 'fastrans' ),
                    ],[
                        'language_dropdown_text' => esc_html__( 'Arabic', 'fastrans' ),
                    ],[
                        'language_dropdown_text' => esc_html__( 'Urdu', 'fastrans' ),
                    ],
                ],
                'title_field' => '{{{ language_dropdown_text }}}',
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'feature_section_style',
			[
				'label' => esc_html__( 'Section Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'section_bg_color',
			[
				'label'     => esc_html__( 'Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .btn-secondary' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Dropdown Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .main-header .header-top .language .dropdown-menu > li > a' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'text_typography',
                'label'          => esc_html__( 'Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .main-header .header-top .language button , .main-header .header-top .language .dropdown-menu > li > a',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
		$this->end_controls_section();


	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();

	?>

            <div class="top-right pull-right">
                <div class="language dropdown">
                    <button class="btn dropdown-toggle" type="button" id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
                        <span class="flag-icon"><img src="<?php echo $settings['language_flag_img']['url']; ?>" alt="" /></span><?php echo $settings['language_text']; ?> &nbsp;<span class="fa fa-angle-down"></span>
                    </button>
                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">

                        <?php foreach ($settings['items'] as $item): ?>

                        <li><a class="dropdown-item" href="#"><?php echo $item['language_dropdown_text']; ?></a></li>

                        <?php endforeach; ?>

                    </ul>
                </div>

            </div>

    <?php 
	
	}

}