<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Home_Three_Banner extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_home_three_banner';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Home Three Banner', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'home_three_banner',
				[
					'label' => esc_html__( 'Home Three Banner', 'fastrans' ),
				]
		);
		$this->add_control(
			'bg_image',
			[
			  'label' => __( 'BG Image', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title Here', 'fastrans' ),
			]
		);
		$this->add_control(
			'animate_title',
			[
				'label'       => __( 'Animated Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Animated Description', 'fastrans' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true, 
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Description', 'fastrans' ),
			]
		);
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title', 'fastrans' ),
			]
		);
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->add_control(
			'video_title',
			[
				'label'       => __( 'Video Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Video Title', 'fastrans' ),
			]
		);
		$this->add_control(
            'video_link',
			[
				'label' => __( 'Video Url', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'label_block' => true, 
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'home_banner_three',
			[
				'label' => esc_html__( 'Home Banner Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-banner-text-content h1' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-banner-text-content h1',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'title_colr_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Title Color Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'color_title_clr',
			[
				'label'     => esc_html__( 'Color Title', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .cd-headline.scale b' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'clr_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .cd-headline.scale b',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'banner_text_colr_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Text Color Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'banner_text_clor',
			[
				'label'     => esc_html__( 'Banner Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-banner-text-content p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'banner_text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-banner-text-content p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'banner_btn_colr_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Button Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'banner_btn_clor',
			[
				'label'     => esc_html__( 'Banner Button Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-banner-text-content .ft-banner-btn-wrapper .ft-banner-btn a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'banner_btn_hover_clor',
			[
				'label'     => esc_html__( 'Banner Button Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-banner-text-content .ft-banner-btn-wrapper .ft-banner-btn a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'banner_btn_bg_clor',
			[
				'label'     => esc_html__( 'Banner BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-banner-text-content .ft-banner-btn-wrapper .ft-banner-btn a' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'banner_btn_hover_bg_clor',
			[
				'label'     => esc_html__( 'Banner Hover BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-banner-text-content .ft-banner-btn-wrapper .ft-banner-btn a:hover' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'banner_btn_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-banner-text-content .ft-banner-btn-wrapper .ft-banner-btn a',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>
	
    <!-- Start of banner section
	============================================= -->
	<section id="ft-banner" class="ft-banner-section" <?php if($settings['bg_image']['id']){ ?>data-background="<?php echo esc_url(wp_get_attachment_url($settings['bg_image']['id'])); ?>"<?php } ?>>
		<div class="ft-banner-content">
			<div class="container">
				<div class="ft-banner-text-content headline pera-content text-center">
					<?php if( $settings['title'] || $settings['animate_title'] ){ ?>
                    <h1 class="cd-headline letters scale"><?php echo wp_kses($settings['title'], true); ?>
						<?php if( $settings['animate_title'] ){ ?>
                        <span class="cd-words-wrapper">
							<?php echo wp_kses($settings['animate_title'], true); ?>
						</span>
                        <?php } ?>
                    </h1>
                    <?php } ?>
                    
                    <?php if( $settings['text'] ){ ?><p> <?php echo wp_kses($settings['text'], true); ?>  </p><?php } ?>
                    <div class="ft-banner-btn-wrapper d-flex justify-content-center align-items-center">
                        <?php if($settings['btn_link']['url'] and $settings['btn_title']){ ?>
                        <div class="ft-banner-btn">
                            <a class="d-flex justify-content-center align-items-center" href="<?php echo esc_url($settings['btn_link']['url'])?>"><?php echo wp_kses($settings['btn_title'], true)?></a>
                        </div>
                        <?php } ?>
                        <?php if($settings['video_link']['url'] and $settings['video_title']){ ?>
                        <div class="ft-banner-video-btn">
                            <a class="video_box" href="<?php echo esc_url($settings['video_link']['url'])?>">
                                <i class="fas fa-play"></i>
                                <span><?php echo wp_kses($settings['video_title'], true)?></span>
                            </a>
                        </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
	<!-- End of banner section
	============================================= -->
    
    <?php 
	
	}

}