<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class home_11_service extends Widget_Base {
 

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home_11_service';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Home 11 Services', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'home_11_Service',
			[
				'label' => esc_html__( 'Service Option', 'fastrans' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'show_top_section',
			[
				'label' => esc_html__( 'Show Top Section', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'fastrans' ),
				'label_off' => esc_html__( 'Hide', 'fastrans' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'What We Do', 'fastrans' ),
				'condition' => [
					'show_top_section' => 'yes',
				],
			]
		);
		$this->add_control(
			'sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'We are Experienced Movers <span>Focused on Quality</span>', 'fastrans' ),
				'condition' => [
					'show_top_section' => 'yes',
				],
			]
		);
		$this->add_control(
			'description',
			[
				'label' => esc_html__( 'Description', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'The easiest way to save money on a move is to simply get rid of the <br> unnecessary household items. Start the pre-move purging process early <br> by cleaning out your in oxer niost closet.', 'fastrans' ),
				'condition' => [
					'show_top_section' => 'yes',
				],
			]
		);
		$this->add_control(
			'--service-content--heading--',
			[
				'label' => esc_html__( 'Service Content', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Service List', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => [
					[
						'name' => 'service_icon',
						'label'       => esc_html__( 'Service Image', 'fastrans' ),
						'type'        => Controls_Manager::MEDIA,
						'label_block' => true,
					],
                    [
						'name' => 'service_title',
						'label'       => esc_html__( 'Service Title', 'fastrans' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default' => __('Residential Move', 'fastrans'),
					],
                    [
                        'name'        => 'service_info',
						'label'       => esc_html__( 'Service Info', 'fastrans' ),
						'type'        => Controls_Manager::TEXTAREA,
						'label_block' => true,
						'default' => __('We are very proud workforce <br> have worked hard create.', 'fastrans'),
					],
					[
						'name'  => 'service_link',
						'label' => esc_html__( 'Service Link', 'fastrans' ),
						'type' => \Elementor\Controls_Manager::URL,
						'placeholder' => esc_html__( 'https://your-link.com', 'fastrans' ),
						'options' => [ 'url', 'is_external', 'nofollow' ],
						'default' => [
							'url' => '#',
							'is_external' => true,
							'nofollow' => true,
							// 'custom_attributes' => '',
						],
						'label_block' => true,
					],
					
				],
				'default' => [
					[
						'service_title' => esc_html__( 'Residential Move', 'fastrans' ),
					],
					[
						'service_title' => esc_html__( 'Commercial Move', 'fastrans' ),
					],
					[
						'service_title' => esc_html__( 'House Shifting', 'fastrans' ),
					],
					[
						'service_title' => esc_html__( 'Industrial Moves', 'fastrans' ),
					],
				],
				'title_field' => '{{{ service_title }}}',
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'Service-style',
			[
				'label' => esc_html__( 'Service Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'custom-container',
			[
				'label' => esc_html__( 'Container Width', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1920,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .custom-container-width' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'serction_background',
				'types' => [ 'classic' ],
				'selector' => '{{WRAPPER}} .ft12-services-section',
			]
		);
		$this->add_control(
			'title-color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-sec-title .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title-typography',
				'label'          => esc_html__( 'Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-sec-title .title',
			]
		);
		$this->add_control(
			'Sub-Title-Color',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-sec-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Sub-Title-Typography',
				'label'          => esc_html__( 'Sub Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-sec-title h2',
			]
		);
		$this->add_control(
			'Info-Color',
			[
				'label'     => esc_html__( 'Info Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-sec-title.light .text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Info-Typography',
				'label'          => esc_html__( 'Info Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-sec-title.light .text',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'service-content-style',
			[
				'label' => __( 'Single Service Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'Box-Border-Color',
			[
				'label'     => esc_html__( 'Box Border Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-service-block .inner-box:before' => 'border-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'box-Before-Title-Border-Color',
			[
				'label'     => esc_html__( 'Before Title Border Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-service-block .icon:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Service-Title--Color',
			[
				'label'     => esc_html__( 'Service Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-service-block h5 a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Service-Title-Hover--Color',
			[
				'label'     => esc_html__( 'Service Title Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-service-block h5 a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Service-Title-Typography',
				'label'          => esc_html__( 'Service Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-service-block h5 a',
			]
		);
		$this->add_control(
			'Service-Info--Color',
			[
				'label'     => esc_html__( 'Service Info Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-service-block .text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Service-Info-Typography',
				'label'          => esc_html__( 'Service Info Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-service-block .text',
			]
		);
		$this->add_control(
			'Icon--Color',
			[
				'label'     => esc_html__( 'Icon Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-service-block .arrow' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Icon-Hover-Color',
			[
				'label'     => esc_html__( 'Icon Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-service-block .inner-box:hover .arrow' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Icon-BG--Color',
			[
				'label'     => esc_html__( 'Icon BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-service-block .arrow' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Icon-Hover-BG--Color',
			[
				'label'     => esc_html__( 'Icon Hover BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-service-block .inner-box:hover .arrow' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Box-Hover-BG--Color',
			[
				'label'     => esc_html__( 'Box Hover BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-service-block .inner-box:hover::before' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .ft12-service-block.col-lg-3.col-md-6.col-sm-12 .inner-box:hover::before' => 'border-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
    ?>
        <!-- Services Section -->
        <section class="ft12-services-section">
            <div class="auto-container custom-container-width">
                <!-- Sec Title -->
                <?php if ('yes' === $settings['show_top_section']): ?>
                <div class="ft12-sec-title light">
                    <div class="d-flex justify-content-between flex-wrap">
                        <div class="left-box">
                            <div class="title"><?php echo esc_html($settings['title']); ?></div>
                            <h2><?php echo wp_kses($settings['sub_title'], true); ?></h2>
                        </div>
                        <div class="right-box">
                            <div class="text"><?php echo wp_kses($settings['description'], true); ?></div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <div class="row clearfix">
                    <?php foreach ($settings['list'] as $item): ?>
                    <!-- Ft12 Service Block -->
                    <div class="ft12-service-block col-lg-3 col-md-6 col-sm-12">
                        <div class="inner-box">
                            <div class="icon"><img src="<?php echo esc_url($item['service_icon']['url']); ?>" alt="" /></div>
                            <h5><a href="<?php echo esc_url($item['service_link']['url']); ?>"><?php echo esc_html($item['service_title']); ?></a></h5>
                            <div class="text"><?php echo wp_kses($item['service_info'], true); ?></div>
                            <a class="arrow theme-btn flaticon-right-arrow" href="<?php echo esc_url($item['service_link']['url']); ?>"></a>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <!-- End Services Section -->
        
	<?php	
	}

}
