<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class home_11_request_form extends Widget_Base {
 


	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home_11_request_form';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Home 11 Request Form', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'home_11_Request_Form',
			[
				'label' => esc_html__( 'Request Form Option', 'fastrans' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'section_bg_img',
			[
				'label' => esc_html__( 'Section Background Image', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'form_title',
			[
				'label' => esc_html__( 'Form Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Request Your Services', 'fastrans' ),
			]
		);
		$this->add_control(
			'form_info',
			[
				'label' => esc_html__( 'Form Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __( 'We here to help you 24/7 with experts', 'fastrans' ),
			]
		);
		$this->add_control(
			'form_shortcode',
			[
				'label' => esc_html__( 'Form Shortcode', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'--Form-Counter--heading--',
			[
				'label' => esc_html__( 'Form Counter Content', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Counter List', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => [
					[
						'name' => 'counter_img',
						'label'       => esc_html__( 'Counter Image', 'fastrans' ),
						'type'        => Controls_Manager::MEDIA,
						'label_block' => true,
					],
					[
						'name' => 'counter_number',
						'label'       => esc_html__( 'Counter Number', 'fastrans' ),
						'type'        => Controls_Manager::NUMBER,
						'label_block' => true,
						'default' => __('351', 'fastrans'),
					],
                    [
						'name' => 'suffix',
						'label'       => esc_html__( 'Counter Suffix', 'fastrans' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default' => __('+', 'fastrans'),
					],
                    [
						'name' => 'counter_title',
						'label'       => esc_html__( 'Counter Title', 'fastrans' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default' => __('Completed Cases', 'fastrans'),
					],
					
				],
				'default' => [
					[
						'counter_title' => esc_html__( 'Completed Cases', 'fastrans' ),
					],
					[
						'counter_title' => esc_html__( 'Happy Customers', 'fastrans' ),
					],
				],
				'title_field' => '{{{ counter_title }}}',
			]
		);
		$this->add_control(
			'--Form-Phone-BOx--heading--',
			[
				'label' => esc_html__( 'Phone Box Content', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'phone_icon',
			[
				'label' => esc_html__( 'Phone Icon', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-circle',
					'library' => 'fa-solid',
				],
			]
		);
		$this->add_control(
			'call_title',
			[
				'label' => esc_html__( 'Call Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('CALL US 24/7', 'fastrans')
			]
		);
		$this->add_control(
			'phone_number',
			[
				'label' => esc_html__( 'Phone Number', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('+880 98 858 231', 'fastrans')
			]
		);
		$this->add_control(
			'--Form-video--heading--',
			[
				'label' => esc_html__( 'Video Content', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'video_url',
			[
				'label' => esc_html__( 'Video Link', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'fastrans' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'Request-Form-style',
			[
				'label' => esc_html__( 'Request Form Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'custom-container',
			[
				'label' => esc_html__( 'Container Width', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1920,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .custom-container-width' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'Form-title-color',
			[
				'label'     => esc_html__( 'Form Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-request-section .form-column .title-box h5' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Form-title-typography',
				'label'          => esc_html__( 'Form Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-request-section .form-column .title-box h5',
			]
		);
		$this->add_control(
			'Form-Info-color',
			[
				'label'     => esc_html__( 'Form Info Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-request-section .form-column .title-box .text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Form-Info-typography',
				'label'          => esc_html__( 'Form Info Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-request-section .form-column .title-box .text',
			]
		);
		$this->add_control(
			'Form-Submit-BG-color',
			[
				'label'     => esc_html__( 'Form Submit BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-default-form .submit-btn' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Form-Submit-Hover-BG-color',
			[
				'label'     => esc_html__( 'Form Submit Hover BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-default-form .submit-btn:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'Counter_style_1',
			[
				'label' => __( 'Counter Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'Counter-Number-Color',
			[
				'label'     => esc_html__( 'Counter Number Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-request-section .counter-column .count-box' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Counter-Number-Typography',
				'label'          => esc_html__( 'Counter Number Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-request-section .counter-column .count-box',
			]
		);
		$this->add_control(
			'Counter-Title-Color',
			[
				'label'     => esc_html__( 'Counter Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-request-section .counter-column .counter-title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Counter-Title-Typography',
				'label'          => esc_html__( 'Counter Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-request-section .counter-column .counter-title',
			]
		);
		$this->add_control(
			'Counter-Border-Color',
			[
				'label'     => esc_html__( 'Counter Border Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-request-section .counter-column .counter-inner' => 'border-color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'Phone-content-style',
			[
				'label' => __( 'Phone Content Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'Phone-BG-Color',
			[
				'label'     => esc_html__( 'Phone BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-request-section .phone-box' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Phone-Icon--Color',
			[
				'label'     => esc_html__( 'Phone Icon Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-request-section .phone-box .icon' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Phone-Icon-BG--Color',
			[
				'label'     => esc_html__( 'Phone Icon BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-request-section .phone-box .icon' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Call-Text-Color',
			[
				'label'     => esc_html__( 'Call Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-request-section .phone-box .box-inner' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Call-Text-Typography',
				'label'          => esc_html__( 'Call Text Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-request-section .phone-box .box-inner',
			]
		);
		$this->add_control(
			'Phone-Number--Color',
			[
				'label'     => esc_html__( 'Phone Number Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-request-section .phone-box a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Phone-Number-Typography',
				'label'          => esc_html__( 'Phone Number Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-request-section .phone-box a',
			]
		);
		$this->add_control(
			'Phone-Number-Hover-Color',
			[
				'label'     => esc_html__( 'Phone Number Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-request-section .phone-box a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'Video-Play-Button-Style',
			[
				'label' => __( 'Video Play Button Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'Play-Button-Color',
			[
				'label'     => esc_html__( 'Play Button Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-request-section .play-box .video_box' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Play-Button-BG-Color',
			[
				'label'     => esc_html__( 'Play Button BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-request-section .play-box .video_box' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'play-button-wave-color-heading',
			[
				'label' => esc_html__( 'Play Button Wave Color', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'play-button-wave-color',
			[
				'label' => esc_html__( 'Button Wave Box Shadow', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::BOX_SHADOW,
				'selectors' => [
					'{{SELECTOR}} #ft12-request-section-id.ft12-request-section .play-box .video_box .ripple, #ft12-request-section-id.ft12-request-section .play-box .video_box .ripple:before, #ft12-request-section-id.ft12-request-section .play-box .video_box .ripple:after' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
    ?>
        <!-- Request Section -->
        <div id="ft12-request-section-id" class="ft12-request-section">
            <div class="image-layer" style="background-image: url(<?php echo esc_url($settings['section_bg_img']['url']); ?>)"></div>
            <div class="auto-container custom-container-width">
                <div class="row clearfix">
                    <!-- Form Column -->
                    <div class="form-column col-lg-5 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <!-- Title Box -->
                            <div class="title-box">
                                <h5><?php echo esc_html($settings['form_title']); ?></h5>
                                <div class="text"><?php echo esc_html($settings['form_info']); ?></div>
                            </div>

                            <!-- Default Form -->
                            <div class="ft12-default-form">
                                <?php echo do_shortcode($settings['form_shortcode']); ?>
                            </div>

                        </div>
                    </div>
                    <!-- Counter Column -->
                    <div class="counter-column col-lg-7 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <div class="row clearfix">
                            <?php foreach ($settings['list'] as $item): ?>
                                <!-- Counter Column -->
                                <div class="counter-column col-lg-6 col-md-6 col-ms-12">
                                    <div class="counter-inner">
                                        <div class="icon"><img src="<?php echo esc_url($item['counter_img']['url']); ?>" alt="" /></div>
                                        <div class="count-outer count-box">
                                            <span class="count-text" data-speed="3500" data-stop="<?php echo esc_attr($item['counter_number']); ?>">0</span><?php echo wp_kses($item['suffix'], true); ?>
                                        </div>
                                        <div class="counter-title"><?php echo esc_html($item['counter_title']); ?></div>
                                    </div>
                                </div>
                            <?php endforeach; ?>

                            </div>

                            <!-- Phone Box -->
                            <div class="phone-box">
                                <div class="box-inner">
                                    <span class="icon">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['phone_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </span>
                                    <?php echo esc_html($settings['call_title']); ?> <br>
                                    <a class="phone" href="tell:<?php echo esc_html($settings['phone_number']); ?>" ><?php echo esc_html($settings['phone_number']); ?></a>
                                </div>
                            </div>

                            <!-- Play Box -->
                            <div class="play-box">
                                <a class="video_box lightbox-image" href="<?php echo esc_url($settings['video_url']['url']); ?>">
                                    <span class="fas fa-play"><i class="ripple"></i></span>
                                </a>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Request Section -->
        
	<?php	
	}

}
