<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class home_11_portfolio extends Widget_Base {


	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home_11_portfolio';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Home 11 Portfolio', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'home_11_Portfolio',
			[
				'label' => esc_html__( 'Portfolio Option', 'fastrans' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'show_top_section',
			[
				'label' => esc_html__( 'Show Top Section', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'fastrans' ),
				'label_off' => esc_html__( 'Hide', 'fastrans' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Our Portfolio', 'fastrans' ),
				'condition' => [
					'show_top_section' => 'yes',
				],
			]
		);
		$this->add_control(
			'sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'We are Experienced Movers <span>Focused on Quality</span>', 'fastrans' ),
				'condition' => [
					'show_top_section' => 'yes',
				],
			]
		);
		$this->add_control(
			'description',
			[
				'label' => esc_html__( 'Description', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'The easiest way to save money on a move is to simply get rid of the <br> unnecessary household items. Start the pre-move purging process early <br> by cleaning out your in oxer niost closet.', 'fastrans' ),
				'condition' => [
					'show_top_section' => 'yes',
				],
			]
		);
		$this->add_control(
			'--Portfolio-content--heading--',
			[
				'label' => esc_html__( 'Portfolio Content', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Portfolio List', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => [
					[
						'name' => 'portfolio_img',
						'label'       => esc_html__( 'Portfolio Image', 'fastrans' ),
						'type'        => Controls_Manager::MEDIA,
						'label_block' => true,
					],
					[
						'name' => 'category_title',
						'label'       => esc_html__( 'Category Title', 'fastrans' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default' => __('Residential', 'fastrans'),
					],
                    [
						'name' => 'portfolio_title',
						'label'       => esc_html__( 'Portfolio Title', 'fastrans' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default' => __('Full House Moving', 'fastrans'),
					],
					[
						'name'  => 'portfolio_link',
						'label' => esc_html__( 'Portfolio Link', 'fastrans' ),
						'type' => \Elementor\Controls_Manager::URL,
						'placeholder' => esc_html__( 'https://your-link.com', 'fastrans' ),
						'options' => [ 'url', 'is_external', 'nofollow' ],
						'default' => [
							'url' => '#',
							'is_external' => true,
							'nofollow' => true,
							// 'custom_attributes' => '',
						],
						'label_block' => true,
					],
					
				],
				'default' => [
					[
						'portfolio_title' => esc_html__( 'Residential Move', 'fastrans' ),
					],
					[
						'portfolio_title' => esc_html__( 'Commercial Move', 'fastrans' ),
					],
					[
						'portfolio_title' => esc_html__( 'House Shifting', 'fastrans' ),
					],
					[
						'portfolio_title' => esc_html__( 'Industrial Moves', 'fastrans' ),
					],
					[
						'portfolio_title' => esc_html__( 'Industrial Moves', 'fastrans' ),
					],
					[
						'portfolio_title' => esc_html__( 'Industrial Moves', 'fastrans' ),
					],
				],
				'title_field' => '{{{ portfolio_title }}}',
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'Portfolio-style',
			[
				'label' => esc_html__( 'Portfolio Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'custom-container',
			[
				'label' => esc_html__( 'Container Width', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1920,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .custom-container-width' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'title-color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-sec-title .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title-typography',
				'label'          => esc_html__( 'Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-sec-title .title',
			]
		);
		$this->add_control(
			'Sub-Title-Color',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-sec-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Sub-Title-Typography',
				'label'          => esc_html__( 'Sub Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-sec-title h2',
			]
		);
		$this->add_control(
			'Info-Color',
			[
				'label'     => esc_html__( 'Info Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-sec-title.light .text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Info-Typography',
				'label'          => esc_html__( 'Info Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-sec-title.light .text',
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'Portfolio-content-style',
			[
				'label' => __( 'Single Portfolio Style', 'appilo' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'Box-Overlay-Color',
			[
				'label'     => esc_html__( 'Box Overlay Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-portfolio-block .overlay-box:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Icon--Color',
			[
				'label'     => esc_html__( 'Icon Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-portfolio-block .arrow' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Icon-BG--Color',
			[
				'label'     => esc_html__( 'Icon BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-portfolio-block .arrow' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Icon-Hover-Color',
			[
				'label'     => esc_html__( 'Icon Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-portfolio-block .arrow:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Icon-Hover-BG--Color',
			[
				'label'     => esc_html__( 'Icon Hover BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-portfolio-block .arrow:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Category-Color',
			[
				'label'     => esc_html__( 'Category Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-portfolio-block .category' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Category-Typography',
				'label'          => esc_html__( 'Category Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-portfolio-block .category',
			]
		);
		$this->add_control(
			'Single-Portfolio-Title-Color',
			[
				'label'     => esc_html__( 'Portfolio Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-portfolio-block h5 a' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Single-Portfolio-Title-Typography',
				'label'          => esc_html__( 'Portfolio Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-portfolio-block h5 a',
			]
		);
		$this->add_control(
			'Single-Portfolio-Title-Hover-Color',
			[
				'label'     => esc_html__( 'Portfolio Title Hover Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-portfolio-block h5 a:hover' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
    ?>
        <!-- Portfolio Section -->
        <div class="ft12-portfolio-section">
            <div class="auto-container custom-container-width">
                <!-- Sec Title -->
		    <?php if ('yes' === $settings['show_top_section']): ?>
                <div class="ft12-sec-title">
                    <div class="d-flex justify-content-between flex-wrap">
                        <div class="left-box">
                            <div class="title"><?php echo esc_html($settings['title']); ?></div>
                            <h2><?php echo wp_kses($settings['sub_title'], true); ?></h2>
                        </div>
                        <div class="right-box">
                            <div class="text"><?php echo wp_kses($settings['description'], true); ?></div>
                        </div>
                    </div>
                </div>
			<?php endif; ?>
                <div class="row clearfix">
                
		        <?php foreach ($settings['list'] as $item): ?>
                    <!-- Portfolio Block -->
                    <div class="ft12-portfolio-block col-lg-4 col-md-6 col-sm-12">
                        <div class="inner-box">
                            <div class="image">
                                <img src="<?php echo esc_url($item['portfolio_img']['url']); ?>" alt="" />
                                <div class="overlay-box">
                                    <a class="arrow flaticon-right-arrow" href="<?php echo esc_url($item['portfolio_link']['url']); ?>"></a>
                                    <div class="content">
                                        <div class="category"><?php echo esc_html($item['category_title']); ?></div>
                                        <h5><a href="<?php echo esc_url($item['portfolio_link']['url']); ?>"><?php echo esc_html($item['portfolio_title']); ?></a></h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
				<?php endforeach; ?>

                </div>
            </div>
        </div>
        <!-- End Portfolio Section -->
        
	<?php	
	}

}
