<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class home_11_feature extends Widget_Base {
 


	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home_11_feature';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Home 11 Features', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'home_11_Feature',
			[
				'label' => esc_html__( 'Feature Option', 'fastrans' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Feature List', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => [
					[
						'name' => 'icon',
						'label'       => esc_html__( 'Icon', 'fastrans' ),
						'type'        => Controls_Manager::MEDIA,
						'label_block' => true,
					],
                    [
						'name' => 'number',
						'label'       => esc_html__( 'Number', 'fastrans' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default' => __('01', 'fastrans'),
					],
                    [
						'name' => 'title',
						'label'       => esc_html__( 'Title', 'fastrans' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default' => __('Give us a Details', 'fastrans'),
					],
                    [
						'name' => 'info',
						'label'       => esc_html__( 'Info', 'fastrans' ),
						'type'        => Controls_Manager::TEXTAREA,
						'label_block' => true,
						'default' => __('We are very proud our workforce and have worked hard create.', 'fastrans'),
					],
					
				],
				'default' => [
					[
						'title' => esc_html__( 'Give us a Details', 'textdomain' ),
					],
					[
						'title' => esc_html__( 'Provide an quote', 'textdomain' ),
					],
					[
						'title' => esc_html__( 'Confirm Your Date', 'textdomain' ),
					],
					[
						'title' => esc_html__( 'Move easy & stress free', 'textdomain' ),
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'slider_banner_style',
			[
				'label' => esc_html__( 'Banner Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'custom-container',
			[
				'label' => esc_html__( 'Container Width', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1920,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .custom-container-width' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'title-color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-feature-block h5' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title-typography',
				'label'          => esc_html__( 'Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-feature-block h5',
			]
		);
		$this->add_control(
			'Number-Color',
			[
				'label'     => esc_html__( 'Number Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-feature-block h5 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Number-Typography',
				'label'          => esc_html__( 'Number Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-feature-block h5 span',
			]
		);
		$this->add_control(
			'Number-BG-Color',
			[
				'label'     => esc_html__( 'Number BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-feature-block h5 span' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Number-Hover-BG-Color',
			[
				'label'     => esc_html__( 'Number Hover BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-feature-block .inner-box:hover h5 span' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Info-Color',
			[
				'label'     => esc_html__( 'Info Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-feature-block .text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Info-Typography',
				'label'          => esc_html__( 'Info Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-feature-block .text',
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
    ?>
        <!-- Featured Section -->
        <div class="ft12-featured-section">
            <div class="auto-container custom-container-width">
                <div class="inner-container">
                    <div class="row clearfix">
                        <?php foreach ($settings['list'] as $item): ?>
                            <!-- Feature Block -->
                            <div class="ft12-feature-block col-xl-3 col-lg-6 col-md-6 col-sm-12">
                                <div class="inner-box">
                                    <div class="icon"><img src="<?php echo esc_url($item['icon']['url']); ?>" alt="" /></div>
                                    <h5>
                                        <?php if (!empty($item['number'])): ?>
                                            <span><?php echo esc_html($item['number']); ?></span>
                                        <?php endif; ?>
                                        <?php echo esc_html($item['title']); ?>
                                    </h5>
                                    <div class="text"><?php echo esc_html($item['info']); ?></div>
                                </div>
                            </div>
                        <?php endforeach; ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Featured Section -->
        
	<?php	
	}

}
