<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class home_11_about extends Widget_Base {
 

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'home_11_about';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Home 11 About', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'home_11_About',
			[
				'label' => esc_html__( 'About Option', 'fastrans' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'ABOUT OUR MOVING', 'fastrans' ),
                'label_block' => true
			]
		);
		$this->add_control(
			'sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __( 'We are Experienced Movers <span>Focused on Quality</span>', 'fastrans' ),
                'label_block' => true
			]
		);
		$this->add_control(
			'bold_text',
			[
				'label' => esc_html__( 'Bold Text', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __( 'The easiest way to save money on a move is to simply get rid offer unnecessary household items your closet.', 'fastrans' ),
                'label_block' => true
			]
		);
		$this->add_control(
			'description',
			[
				'label' => esc_html__( 'Description', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __( 'The easiest way to save money on a move is to simply get rid of the unnecessary household items. Start the pre-move purging process early by cleaning out your in oxer niost closet.', 'fastrans' ),
                'label_block' => true
			]
		);
		$this->add_control(
			'about_img',
			[
				'label' => esc_html__( 'About Image', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Feature List', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => [
                    [
						'name' => 'feature_list',
						'label'       => esc_html__( 'Feature List', 'fastrans' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default' => __('Work hard to keep secure', 'fastrans'),
					],
					
				],
				'default' => [
					[
						'feature_list' => esc_html__( 'Work hard to keep secure', 'fastrans' ),
					],
					[
						'feature_list' => esc_html__( 'Work hard to keep secure', 'fastrans' ),
					],
					[
						'feature_list' => esc_html__( 'Work hard to keep secure', 'fastrans' ),
					],
					[
						'feature_list' => esc_html__( 'Work hard to keep secure', 'fastrans' ),
					],
				],
				'title_field' => '{{{ feature_list }}}',
			]
		);
		$this->add_control(
			'award_img',
			[
				'label' => esc_html__( 'Award Image', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
		$this->add_control(
			'number',
			[
				'label' => esc_html__( 'Number', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'step' => 1,
				'default' => 20,
			]
		);
		$this->add_control(
			'suffix',
			[
				'label' => esc_html__( 'Suffix', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '+', 'fastrans' ),
				'label_block' => true
			]
		);
		$this->add_control(
			'experience_text',
			[
				'label' => esc_html__( 'Experience Text', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __( 'Year Of Working <br> Experiance', 'fastrans' ),
				'label_block' => true
			]
		);
		$this->add_control(
			'signature_box_switch',
			[
				'label' => esc_html__( 'Signature Box Switch', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'fastrans' ),
				'label_off' => esc_html__( 'Hide', 'fastrans' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'name',
			[
				'label' => esc_html__( 'Name', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'Prince La Lakim', 'fastrans' ),
				'label_block' => true,
				'condition' => [
					'signature_box_switch' => 'yes',
				],
			]
		);
		$this->add_control(
			'designation',
			[
				'label' => esc_html__( 'Designation', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'CEO, Founder', 'fastrans' ),
				'label_block' => true,
				'condition' => [
					'signature_box_switch' => 'yes',
				],
			]
		);
		$this->add_control(
			'signature_img',
			[
				'label' => esc_html__( 'Signature Image', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'condition' => [
					'signature_box_switch' => 'yes',
				],
    
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'About_style',
			[
				'label' => esc_html__( 'About Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'custom-container',
			[
				'label' => esc_html__( 'Container Width', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1920,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .custom-container-width' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'--title-options--',
			[
				'label' => esc_html__( 'Title Options', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'title-color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-sec-title .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title-typography',
				'label'          => esc_html__( 'Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-sec-title .title',
			]
		);
		$this->add_control(
			'--sub-title-options--',
			[
				'label' => esc_html__( 'Sub Title Options', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Sub-title-color',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-sec-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Sub-title-typography',
				'label'          => esc_html__( 'Sub Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-sec-title h2',
			]
		);
		$this->add_control(
			'--Info-text-options--',
			[
				'label' => esc_html__( 'Info Options', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Bold-Text-color',
			[
				'label'     => esc_html__( 'Bold Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-about-section .ft12-sec-title .bold-text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Bold-Text-typography',
				'label'          => esc_html__( 'Bold Text Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-about-section .ft12-sec-title .bold-text',
			]
		);
		$this->add_control(
			'Description-color',
			[
				'label'     => esc_html__( 'Description Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-sec-title .text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Description-typography',
				'label'          => esc_html__( 'Description Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-sec-title .text',
			]
		);
		$this->add_control(
			'--features-options--',
			[
				'label' => esc_html__( 'Features Options', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Feature-Color',
			[
				'label'     => esc_html__( 'Feature Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-about-section .check li' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Feature-Icon-Color',
			[
				'label'     => esc_html__( 'Feature Icon Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-about-section .check li:before' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Feature-Icon-BG-Color',
			[
				'label'     => esc_html__( 'Feature Icon BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-about-section .check li:before' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Feature-Typography',
				'label'          => esc_html__( 'Feature Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-about-section .check li',
			]
		);
		$this->add_control(
			'--Experience-options--',
			[
				'label' => esc_html__( 'Experience Options', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Experience-Box-BG-Color',
			[
				'label'     => esc_html__( 'Experience Box BG Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-experiance-box .box-inner' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'Counter-Number-Color',
			[
				'label'     => esc_html__( 'Counter Number Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-experiance-box .count-box' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Counter-Number-Typography',
				'label'          => esc_html__( 'Counter Number Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-experiance-box .count-box',
			]
		);
		$this->add_control(
			'Experience-Text-Color',
			[
				'label'     => esc_html__( 'Experience Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-experiance-box .experience-text' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Experience-Text-Typography',
				'label'          => esc_html__( 'Experience Text Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-experiance-box .experience-text',
			]
		);
		$this->add_control(
			'--Author-options--',
			[
				'label' => esc_html__( 'Author Options', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'Name-Color',
			[
				'label'     => esc_html__( 'Name Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-about-section .signature-box strong' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Name-Typography',
				'label'          => esc_html__( 'Name Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-about-section .signature-box strong',
			]
		);
		$this->add_control(
			'Designation-Color',
			[
				'label'     => esc_html__( 'Designation Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft12-about-section .signature-box .designation' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'Designation-Typography',
				'label'          => esc_html__( 'Designation Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft12-about-section .signature-box .designation',
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		
    ?>
        <!-- About Section -->
        <div class="ft12-about-section">
            <div class="auto-container custom-container-width">
                <!-- Sec Title -->
                <div class="ft12-sec-title">
                    <div class="d-flex justify-content-between flex-wrap">
                        <div class="left-box">
                            <div class="title"><?php echo esc_html($settings['title']); ?></div>
                            <h2><?php echo wp_kses($settings['sub_title'], true); ?></h2>
                        </div>
                        <div class="right-box">
                            <?php if (!empty($settings['bold_text'])): ?>
                                <div class="bold-text"><?php echo wp_kses($settings['bold_text'], true); ?></div>
                            <?php endif; ?>
                            <?php if (!empty($settings['description'])): ?>
                                <div class="text"><?php echo wp_kses($settings['description'], true); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row clearfix">

                    <!-- Image Column -->
                    <div class="image-column col-lg-6 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <div class="image">
                                <?php if (!empty($settings['about_img']['url'])): ?>
                                    <img src="<?php echo esc_url($settings['about_img']['url']); ?>" alt="" />
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Content Column -->
                    <div class="content-column col-lg-6 col-md-12 col-sm-12">
                        <div class="inner-column">
                            <div class="row clearfix">

                                <!-- Column -->
                                <div class="column col-lg-6 col-md-6 col-sm-12">
                                    <ul class="check">
                                        <?php foreach ($settings['list'] as $item): ?>
                                            <li><?php echo wp_kses($item['feature_list'], true); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                                <!-- Column -->
                                <div class="column col-lg-6 col-md-6 col-sm-12">
                                    <div class="ft12-experiance-box">
                                        <div class="box-inner">
                                            <?php if (!empty($settings['award_img']['url'])): ?>
                                                <span class="icon"><img src="<?php echo esc_url($settings['award_img']['url']); ?>" alt="" /></span>
											<?php endif; ?>
                                            <div class="count-outer count-box">
                                                <span class="count-text" data-speed="3500" data-stop="<?php echo esc_attr($settings['number']); ?>">0</span><?php echo wp_kses($settings['suffix'], true); ?>
                                            </div>
                                            <div class="experience-text">
												<?php echo wp_kses($settings['experience_text'], true); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <?php if ('yes' === $settings['signature_box_switch']): ?>
                                <!-- Signature Box -->
                                <div class="signature-box">
                                    <div class="box-inner">
                                        <strong><?php echo esc_html($settings['name']); ?></strong><br>
                                        <div class="designation">
											<?php echo esc_html($settings['designation']); ?>
                                        </div>
                                        <span class="signature">
                                            <img src="<?php echo esc_url($settings['signature_img']['url']); ?>" alt="" />
                                        </span>
                                    </div>
                                </div>
                            <?php endif; ?>

                        </div>
                    </div>

                </div>
            </div>
        </div>
        <!-- End About Section -->
        
	<?php	
	}

}
