<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Ft_Our_Services extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_ft_our_services';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'FT Services', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'ft_our_services',
			[
				'label' => esc_html__( 'FT Services', 'fastrans' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your title', 'fastrans' ),
			]
		);
		$this->add_control(
              'services', 
			  	[
            		'type' => Controls_Manager::REPEATER,
            		'separator' => 'before',
            		'default' => 
						[
                			['title1' => esc_html__('Air Freight', 'fastrans')],
                			['title1' => esc_html__('Ocean Freight', 'fastrans')],
							['title1' => esc_html__('Road Freight', 'fastrans')],
            			],
            		'fields' => 
						[
                			[
                    			'name' => 'title1',
                    			'label' => esc_html__('Title', 'fastrans'),
								'label_block' => true,
                    			'type' => Controls_Manager::TEXT,
                    			'default' => esc_html__('Enter Title Here', 'fastrans')
                			],
							[
                    			'name' => 'text1',
                    			'label' => esc_html__('Text', 'fastrans'),
                    			'type' => Controls_Manager::TEXTAREA,
                    			'default' => esc_html__('', 'fastrans')
                			],
							[
                    			'name' => 'btn_title',
                    			'label' => esc_html__('Button Title', 'fastrans'),
								'label_block' => true,
                    			'type' => Controls_Manager::TEXT,
                    			'default' => esc_html__('', 'fastrans')
                			],
							[
                    			'name' => 'btn_link',
								'label' => __( 'External Url', 'fastrans' ),
							    'type' => Controls_Manager::URL,
							    'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
							    'show_external' => true,
							    'default' => ['url' => '','is_external' => true,'nofollow' => true,],
                			],
							[
                    			'name' => 'feature_image',
                    			'label' => __( 'Feature Image', 'fastrans' ),
								'type' => Controls_Manager::MEDIA,
								'default' => ['url' => Utils::get_placeholder_image_src(),],
                			],
            			],
            	    'title_field' => '{{title1}}',
                 ]
        );
		$this->end_controls_section();
	}

	/**
	 * Render button widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');
		?>
		
        <!-- Services Section -->
        <section class="services-section">
            <div class="container">
                <div class="ft-section-title headline pera-content text-center">
                    <span class="sub-title"><?php echo wp_kses( $settings['subtitle'], true );?></span>
                    <h2><?php echo wp_kses( $settings['title'], true );?></h2>
                </div>
                <div class="row">
                    <?php $count = 1; foreach($settings['services'] as $key => $item):?>
                    <div class="col-lg-4 service-block-one">
                        <div class="inner-box wow fadeInUp" data-wow-duration="1500ms">
                            
                            <h4><?php echo wp_kses($item['title1'], $allowed_tags);?></h4>
                            <div class="text"><?php echo wp_kses($item['text1'], $allowed_tags);?></div>
                            <div class="read-more-btn"><a href="<?php echo esc_url($item['btn_link']['url']);?>" class="link"><i class="fas fa-arrow-right"></i><?php echo wp_kses($item['btn_title'], $allowed_tags);?></a></div>
                            <div class="count"><span><?php $count = sprintf('%02d', $count); echo $count; ?></span></div>
                            <?php if($item['feature_image']['id']):?><div class="image" data-parallax='{"y": 30}'><img src="<?php echo esc_url(wp_get_attachment_url($item['feature_image']['id'] ));?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>"></div><?php endif; ?>
                        </div>
                    </div>
                    <?php $count++; endforeach;?>
                </div>
            </div>
        </section>
        
        <?php 
	}

}
