<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class Faqs_And_Services extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_faqs_and_services';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Faqs and Services', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'faqs_and_services',
			[
				'label' => esc_html__( 'Our Faqs', 'fastrans' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
			]
		);
		$this->add_control(
            'subtitle',
            [
                'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active' => true,
                ],
                'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'fastrans' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
                'placeholder' => __( 'Enter your Title', 'fastrans' ),
            ]
        );
		$this->add_control(
        	'accordion', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
					[
						['acc_title' => esc_html__('Can i specify a delivery date when ordering?', 'fastrans')],
						['acc_title' => esc_html__('What payment methods are supported?', 'fastrans')],
						['acc_title' => esc_html__('What is Federation of International Trade Association?', 'fastrans')],
						['acc_title' => esc_html__('How can I Track My Shipments?', 'fastrans')]
					],
				'fields' => 
					[
						[
							'name' => 'acc_title',
							'label' => esc_html__('Accordion Title', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'fastrans')
						],
						[
							'name' => 'acc_text',
							'label' => esc_html__('Accordion Description', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'fastrans')
						],
					],
				'title_field' => '{{acc_title}}',
            ]
        );
		
		$this->end_controls_section();
		
		//Our Services
		$this->start_controls_section(
            'our_services',
            [
                'label' => esc_html__( 'Our Services', 'fastrans' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
		$this->add_control(
            'subtitle2',
            [
                'label'       => __( 'Sub Title', 'fastrans' ),
				'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active' => true,
                ],
                'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
            ]
        );
        $this->add_control(
            'title2',
            [
                'label'       => __( 'Title', 'fastrans' ),
                'type'        => Controls_Manager::TEXTAREA,
                'dynamic'     => [
                    'active' => true,
                ],
                'placeholder' => __( 'Enter your Title', 'fastrans' ),
            ]
        );
		$this->add_control(
        	'services', 
				[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' => 
					[
						['services_title' => esc_html__('Safe Packing', 'fastrans')],
						['services_title' => esc_html__('Right Time Delivery', 'fastrans')],
						['services_title' => esc_html__('Ship everywhere', 'fastrans')],
						['services_title' => esc_html__('Fastest Shipping', 'fastrans')]
					],
				'fields' => 
					[
						[
							'name' => 'icons',
							'label' => esc_html__('Enter The icons', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::SELECT2,
							'options'  => get_fontawesome_icons(),
						],
						[
							'name' => 'services_title',
							'label' => esc_html__('Title', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::TEXT,
							'label_block' => true,
						],
						[
							'name' => 'services_text',
							'label' => esc_html__('Description', 'fastrans'),
							'label_block' => true,
							'type' => Controls_Manager::TEXTAREA,
							'default' => esc_html__('', 'fastrans')
						],
					],
				'title_field' => '{{services_title}}',
            ]
        );
		$this->end_controls_section();
		$this->start_controls_section(
			'faq_heading_style',
			[
				'label' => esc_html__( 'Faq Heading Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'faq_sub_hd_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Sub Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sub_title_clr',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-2 .sub-title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sub_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-2 .sub-title',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'faq_hd_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Heading Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'faq_title_clr',
			[
				'label'     => esc_html__( 'Faq Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title-2 h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'faq_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title-2 h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'faq__style',
			[
				'label' => esc_html__( 'Faq Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'faq_item_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Faq Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'faq_item_title_clr',
			[
				'label'     => esc_html__( 'Faq Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-faq-content .accordion-item .accordion-button' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'faq_item_ac_title_clr',
			[
				'label'     => esc_html__( 'Faq Title Active Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-faq-content .accordion-item .accordion-button:not(.collapsed)' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'faq_item_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-faq-content .accordion-item .accordion-button',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'faq_item_text_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Faq Text Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'faq_item_text_clr',
			[
				'label'     => esc_html__( 'Faq Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-faq-content .accordion-body' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'faq_item_text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-faq-content .accordion-body',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'service__style',
			[
				'label' => esc_html__( 'Service Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'serv_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Service Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'serv_title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-why-choose-feature-list-item-2 .ft-why-choose-feature-text h3' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'serv_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-why-choose-feature-list-item-2 .ft-why-choose-feature-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'serv_text_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Service Text Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'serv_text_clr',
			[
				'label'     => esc_html__( 'Faq Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-why-choose-feature-text.pera-content p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'serv_text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-why-choose-feature-text.pera-content p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->end_controls_section();
	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>

	<!-- Start of FAQ why choose  section
	============================================= -->
	<section id="ft-faq-why-choose-us" class="ft-faq-why-choose-us-section">
		<div class="container">
			<div class="ft-faq-why-choose-content">
				<div class="row">
					<div class="col-lg-6">
						<div class="ft-faq-content">
							<?php if( $settings['subtitle'] || $settings['title'] ){ ?>
                            <div class="ft-section-title-2 headline pera-content">
								<?php if( $settings['subtitle'] ){ ?><span class="sub-title"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
                				<?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>
							</div>
                            <?php } ?>
							<div class="accordion" id="accordionExample">
								<?php $count = 1; foreach($settings['accordion'] as $key => $item): ?>
                                <div class="accordion-item headline pera-content">
									<h2 class="accordion-header" id="headingOne<?php echo esc_attr($count); ?>">
										<button class="accordion-button <?php if($count == 1) echo ''; else echo 'collapsed'; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne<?php echo esc_attr($count); ?>" aria-expanded="true" >
											<?php echo wp_kses($item['acc_title'], true);?>
										</button>
									</h2>
									<div id="collapseOne<?php echo esc_attr($count); ?>" class="accordion-collapse collapse <?php if($count == 1) echo 'show'; ?>" data-bs-parent="#accordionExample">
										<div class="accordion-body">
											<?php echo wp_kses($item['acc_text'], true);?> 
										</div>
									</div>
								</div>
                                <?php $count++; endforeach; ?>
							</div>	
						</div>
					</div>
					<div class="col-lg-6">
						<div class="ft-why-choose-content-2">
							<?php if( $settings['subtitle2'] || $settings['title2'] ){ ?>
                            <div class="ft-section-title-2 headline pera-content">
								<?php if( $settings['subtitle2'] ){ ?><span class="sub-title"><?php echo wp_kses($settings['subtitle2'], true)?></span><?php } ?>
                				<?php if( $settings['title2'] ){ ?><h2><?php echo wp_kses($settings['title2'], true)?></h2><?php } ?>
							</div>
							<?php } ?>
                            <div class="ft-why-choose-feature-wrapper-2">
								<div class="row">
									<?php foreach($settings['services'] as $key => $item): ?>
                                    <div class="col-lg-6">
										<div class="ft-why-choose-feature-list-item-2">
											<div class="ft-why-choose-feature-icon">
												<i class="<?php echo esc_attr(str_replace( "icon ",  "", $item['icons']));?>"></i>
											</div>
											<div class="ft-why-choose-feature-text headline pera-content">
												<h3><?php echo wp_kses($item['services_title'], true);?></h3>
												<p><?php echo wp_kses($item['services_text'], true);?></p>
											</div>
										</div>
									</div>
                                    <?php endforeach; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>						
	<!-- End of FAQ why choose  section
	============================================= -->
		
    <?php 
	
	}

}