<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
use \Elementor\Group_Control_Background;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class About_Us_V4 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'about_us_v4';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About Us V4', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return ' eicon-form-horizontal';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}
	
	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'about_section',
				[
					'label' => esc_html__( 'About Section', 'fastrans' ),
				]
		);
        $this->add_control(
            'image_one',
            [
                'label' => esc_html__( 'Image One', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'image_two',
            [
                'label' => esc_html__( 'Image Two', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'image_three',
            [
                'label' => esc_html__( 'Image Three', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'bg_shape',
            [
                'label' => esc_html__( 'Backgorund Shape', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
			'sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'We are Here', 'fastrans' ),
				'placeholder' => esc_html__( 'Type your sub title here', 'fastrans' ),
                'label_block' => true,
			]
		);
        $this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Express Delivery for Courier Service', 'fastrans' ),
				'placeholder' => esc_html__( 'Type your title here', 'fastrans'),
                'label_block' => true,
			]
		);
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'label' => esc_html__( 'Background', 'fastrans' ),
				'types' => [ 'classic' ],
				'selector' => '{{WRAPPER}} .ftn-section-title h2 span::after',
			]
		);

        $this->add_control(
			'content',
			[
				'label' => esc_html__( 'Content', 'fastrans' ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => esc_html__( ' To be travel management leaders in regions in which we operate, innovative technology to improve the customer experience and bring positive change to the market. ', 'fastrans' ),
				'placeholder' => esc_html__( 'Type your content here', 'fastrans'),
                'label_block' => true,
			]
		);

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );

        $repeater->add_control(
            'label',
            [
                'label' => esc_html__( 'Title', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Local:', 'fastrans' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'number',
            [
                'label' => esc_html__( 'Number', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( '01-888-452-1505', 'fastrans' ),
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__( 'CTA List', 'fastrans' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'label' => esc_html__( 'Local:', 'fastrans' ),
                        'number' => esc_html__( '01-888-452-1505', 'fastrans' ),
                    ]
                ],
                'title_field' => '{{{ number }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Section Title Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'sub_title_color',
			[
				'label'     => esc_html__( 'Sub Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-section-title .sub-title' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'           => 'sub_title_typography',
                'label'          => esc_html__( 'Typography', 'fastrans' ),
                'selector'       => '{{WRAPPER}} .ftn-section-title .sub-title',
                'fields_options' => [
                    'typography' => [
                        'default' => 'custom',
                    ],
                ],
            ]
        );
		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-section-title h2' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'title_highlight_color',
			[
				'label'     => esc_html__( 'Title Highlight Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-section-title h2 span' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Sub Title Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ftn-section-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'content_color',
			[
				'label'     => esc_html__( 'Content Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-about-text-area .ftn-about-text-desc' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'content_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ftn-about-text-area .ftn-about-text-desc',
			]
		);

        $this->add_control(
			'cta_h',
			[
				'label' => esc_html__( 'CTA', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'cta_icon_color',
			[
				'label'     => esc_html__( 'Icon Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-about-text-area .fta-about-cta .inner-icon' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_control(
			'cta_icon_bg_color',
			[
				'label'     => esc_html__( 'Icon Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-about-text-area .fta-about-cta .inner-icon' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'cta_label_color',
			[
				'label'     => esc_html__( 'Label Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-about-text-area .fta-about-cta .inner-text .ftn-title' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'cta_label_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ftn-about-text-area .fta-about-cta .inner-text .ftn-title',
			]
		);
        $this->add_control(
			'cta_number_color',
			[
				'label'     => esc_html__( 'Label Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ftn-about-text-area .fta-about-cta .inner-text span' => 'color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'cta_number_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ftn-about-text-area .fta-about-cta .inner-text span',
			]
		);

		$this->end_controls_section();

	}
	
	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();

	?>

        <!-- Feature Section -->
        <section id="ftn-about" class="ftn-about-section">
		<div class="ftn-about-content d-flex">
			<div class="ftn-about-img-wrapper d-flex">
                <?php if(!empty($settings['image_one']['url'])):?>
				<div class="ftn-about-img1">
					<img src="<?php echo esc_url($settings['image_one']['url']);?>" alt="<?php echo esc_attr($settings['image_one']['alt']);?>">
				</div>
                <?php endif; ?>
                
				<div class="ftn-about-img-wrap">

                    <?php if(!empty($settings['image_two']['url'])):?>
					<div class="ftn-about-img2">
						<img src="<?php echo esc_url($settings['image_two']['url']);?>" alt="<?php echo esc_attr($settings['image_two']['alt']);?>">
					</div>
                    <?php endif; ?>

                    <?php if(!empty($settings['image_three']['url'])):?>
					<div class="ftn-about-img3">
						<img src="<?php echo esc_url($settings['image_three']['url']);?>" alt="<?php echo esc_attr($settings['image_three']['alt']);?>">
					</div>
                    <?php endif; ?>
				</div>
			</div>
			<div class="ftn-about-text-wrapper" data-background="<?php echo esc_attr($settings['bg_shape']['url']); ?>">
				<div class="ftn-about-text-area">
					<div class="ftn-section-title headline  wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
                    <?php if(!empty($settings['sub_title'])):?>
                    <span class="sub-title text-uppercase"><?php echo esc_html( $settings['sub_title']);?></span>
                    <?php endif;?>

                    <?php if(!empty($settings['title'])):?>
                    <h2><?php echo $settings['title'];?></h2>
                    <?php endif;?>
					</div>

                    <?php if(!empty($settings['content'])): ?>
					<div class="ftn-about-text-desc  wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
						<?php echo esc_html($settings['content']); ?>
					</div>
                    <?php endif; ?>

					<div class="ftn-about-cta-area d-flex  wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1500ms">

                    
                        <?php foreach ($settings['items'] as $item): ?>
                            <div class="fta-about-cta d-flex align-items-center">

                                <?php if(!empty($item['icon'])): ?>
                                <div class="inner-icon d-flex align-items-center justify-content-center">
                                    <?php \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                </div>
                                <?php endif; ?>
                                
                                <div class="inner-text">

                                    <?php if(!empty($item['label'])):?>
                                    <span class="ftn-title"><?php echo esc_html($item['label']);?></span>
                                    <?php endif;?>
                                    
                                    <?php if(!empty($item['number'])):?>
                                    <span class="ftn-value"><?php echo esc_html($item['number']);?></span>
                                    <?php endif;?>
                                </div>
                            </div>
                        <?php endforeach; ?>
					</div>
				</div>
			</div>
		</div>
	</section>
        <!-- End Feature Section -->

    <?php 
	
	}

}