<?php

namespace FASTRANSPLUGIN\Element;

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;

/**
 * Elementor button widget.
 * Elementor widget that displays a button with the ability to control every
 * aspect of the button design.
 *
 * @since 1.0.0
 */
class About_Us_V2 extends Widget_Base {

	/**
	 * Get widget name.
	 * Retrieve button widget name.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'fastrans_about_us_v2';
	}

	/**
	 * Get widget title.
	 * Retrieve button widget title.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About Us V2', 'fastrans' );
	}

	/**
	 * Get widget icon.
	 * Retrieve button widget icon.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-library-open';
	}

	/**
	 * Get widget categories.
	 * Retrieve the list of categories the button widget belongs to.
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since  2.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'fastrans' ];
	}

	/**
	 * Register button widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since  1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'about_us_v2',
				[
					'label' => esc_html__( 'About Us V2', 'fastrans' ),
				]
		);
		$this->add_control(
			'about_image',
			[
			  'label' => __( 'About Image', 'fastrans' ),
			  'type' => Controls_Manager::MEDIA,
			  'default' => ['url' => Utils::get_placeholder_image_src(),],
			]
	    );
		$this->add_control(
            'show_experience_box',
			[
				'label' => __( 'Enable/Disable Experience Box', 'fastrans' ),
				'type'     => Controls_Manager::SWITCHER,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enable/Disable Experience Box', 'fastrans' ),
			]
		);
		$this->add_control(
			'experience_year',
			[
				'label'       => __( 'Year Of Experience', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Year Of Experience', 'fastrans' ),
			]
		);
		$this->add_control(
			'alphabet_year',
			[
				'label'       => __( 'Enter Years', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter Years', 'fastrans' ),
			]
		);
		$this->add_control(
			'experience_description',
			[
				'label'       => __( 'Experience Description', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Experience Description', 'fastrans' ),
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'       => __( 'Sub Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Title', 'fastrans' ),
			]
		);
		$this->add_control(
			'text',
			[
				'label'       => __( 'Text', 'fastrans' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your text', 'fastrans' ),
			]
		);
		$this->add_control(
            'services',
			  	[
					'type' => Controls_Manager::REPEATER,
					'separator' => 'before',
					'default' =>
				[
					['block_title' => esc_html__('Global Service', 'fastrans')],
					['block_title' => esc_html__('Local Service', 'fastrans')]
				],
			'fields' =>
				[
					[
						'name' => 'icons',
						'label' => esc_html__('Enter The icons', 'fastrans'),
						'type' => Controls_Manager::SELECT2,
						'options'  => get_fontawesome_icons(),
					],
					[
						'name' => 'block_title',
						'label' => esc_html__('Title', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__('', 'fastrans')
					],
					[
						'name' => 'block_text',
						'label' => esc_html__('Description', 'fastrans'),
						'label_block' => true,
						'type' => Controls_Manager::TEXTAREA,
						'default' => esc_html__('', 'fastrans')
					],
				],
				'title_field' => '{{block_title}}',
            ]
        );
		$this->add_control(
			'btn_title',
			[
				'label'       => __( 'Button Title', 'fastrans' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'dynamic'     => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Button Title', 'fastrans' ),
			]
		);
		$this->add_control(
            'btn_link',
			[
				'label' => __( 'Button Url', 'fastrans' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
				'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'about_style',
			[
				'label' => esc_html__( 'About Style', 'fastrans' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'year_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Year Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'year_clr',
			[
				'label'     => esc_html__( 'Year Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-about-exp-area .ft-about-exp-text h3' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'year_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-service-innerbox-3 .ft-service-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'exp_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Exprience Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'exp_title_clr',
			[
				'label'     => esc_html__( 'Exp Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-about-exp-area .ft-about-exp-text p' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'exp_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-about-exp-area .ft-about-exp-text p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);

		$this->add_control(
			'sub_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Sub Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'sub_title_clr',
			[
				'label'     => esc_html__( 'Exp Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title .sub-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'sub_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title .sub-title',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Sub Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'title_clr',
			[
				'label'     => esc_html__( 'Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-section-title h2' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-section-title h2',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'text_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Text Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'text_clr',
			[
				'label'     => esc_html__( 'Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-about-text-wrapper .pera-content p' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-about-text-wrapper .pera-content p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'feature_title_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Feature Title Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'feature_title_clr',
			[
				'label'     => esc_html__( 'Feature Title Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-about-feature-list-item .ft-about-feature-text h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'feature_title_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-about-feature-list-item .ft-about-feature-text h3',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);
		$this->add_control(
			'feature_text_style',
			[
				'type'      => Controls_Manager::HEADING,
				'label'     => esc_html__( 'Feature Text Style', 'fastrans' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'feature_text_clr',
			[
				'label'     => esc_html__( 'Feature Text Color', 'fastrans' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ft-about-feature-text p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'           => 'feature_text_typography',
				'label'          => esc_html__( 'Typography', 'fastrans' ),
				'selector'       => '{{WRAPPER}} .ft-about-feature-text p',
				'fields_options' => [
					'typography' => [
						'default' => 'custom',
					],
				],
			]
		);

		$this->end_controls_section();
	}

	/**

	 * Render button widget output on the frontend.
	* Written in PHP and used to generate the final HTML.
	*
	* @since  1.0.0
	* @access protected
	*/

	protected function render() {

		$settings = $this->get_settings_for_display();
		$allowed_tags = wp_kses_allowed_html('post');

	?>

    <!-- Start of About section
	============================================= -->
	<section id="ft-about" class="ft-about-section">
		<div class="container">
			<div class="ft-about-content">
				<div class="row">
					<div class="col-lg-6 wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
						<div class="ft-about-img-exp position-relative">
							<?php if($settings['show_experience_box']){ ?>
                            <div class="ft-about-exp-area headline pera-content position-absolute">
								<div class="ft-about-exp-img">
									<img src="<?php echo esc_url(get_template_directory_uri());?>/assets/images/shape/exp-sh1.png" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>">
								</div>
								<div class="ft-about-exp-text position-absolute">
									<h3><span class="counter"><?php echo wp_kses($settings['experience_year'], true)?></span><?php echo wp_kses($settings['alphabet_year'], true)?></h3>
									<?php if($settings['experience_description']){ ?><p><?php echo wp_kses($settings['experience_description'], true)?></p><?php } ?>
								</div>
							</div>
                            <?php } ?>
							<?php if($settings['about_image']['id']){ ?>
                            <div class="ft-about-img">
                                <img src="<?php echo esc_url(wp_get_attachment_url($settings['about_image']['id'])); ?>" alt="<?php esc_attr_e('Awesome Image', 'fastrans'); ?>">
                            </div>
                            <?php } ?>
						</div>
					</div>
					<div class="col-lg-6">
						<div class="ft-about-text-wrapper">
							<?php if( $settings['subtitle'] || $settings['title'] || $settings['text'] ){ ?>
                            <div class="ft-section-title headline pera-content">
								<?php if( $settings['subtitle'] ){ ?><span class="sub-title"><?php echo wp_kses($settings['subtitle'], true)?></span><?php } ?>
								<?php if( $settings['title'] ){ ?><h2><?php echo wp_kses($settings['title'], true)?></h2><?php } ?>
								<?php if( $settings['text'] ){ ?><p><?php echo wp_kses($settings['text'], true)?> </p><?php } ?>
							</div>
                            <?php } ?>
							<div class="ft-about-feature-list-warpper">
								<?php foreach($settings['services'] as $key => $item): ?>
                                <div class="ft-about-feature-list-item d-flex align-items-center wow fadeInUp" data-wow-delay="0ms" data-wow-duration="1500ms">
									<div class="ft-about-feature-icon d-flex align-items-center justify-content-center">
										<i class="<?php echo esc_attr(str_replace( "icon ",  "", $item['icons']));?>"></i>
									</div>
									<div class="ft-about-feature-text headline pera-content">
										<h3><?php echo esc_attr($item['block_title']);?></h3>
										<p><?php echo esc_attr($item['block_text']);?></p>
									</div>
								</div>
                                <?php endforeach; ?>

                                <?php if( $settings['btn_title'] and $settings['btn_link']['url'] ){ ?>
								<div class="ft-btn wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1500ms">
									<a class="d-flex justify-content-center align-items-center" href="<?php echo esc_url($settings['btn_link']['url']); ?>"><?php echo wp_kses($settings['btn_title'], true); ?></a>
								</div>
                                <?php } ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- End of About section
	============================================= -->

    <?php

	}

}